/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.annotation.OrmConstructor;
import org.nkjmlab.sorm4j.annotation.OrmRecord;
import org.nkjmlab.sorm4j.internal.mapping.ConstructorBasedSqlResultCreator;
import org.nkjmlab.sorm4j.internal.mapping.SetterBasedSqlResultContainerCreator;
import org.nkjmlab.sorm4j.internal.mapping.SqlResultContainerCreator;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.mapping.ColumnValueToJavaObjectConverters;

public final class SqlResultToColumnsMapping<T> {
    private static final ConcurrentMap<Class<?>, String[]> primaryKeyColumnLabels = new ConcurrentHashMap();
    private final Class<T> objectClass;
    private final ColumnValueToJavaObjectConverters columnValueConverter;
    private final ColumnToAccessorMapping columnToAccessorMap;
    private final Map<String, int[]> columnTypesMap = new ConcurrentHashMap<String, int[]>();
    private final SqlResultContainerCreator<T> containerObjectCreator;

    public SqlResultToColumnsMapping(ColumnValueToJavaObjectConverters converter, Class<T> objectClass, ColumnToAccessorMapping columnToAccessorMap) {
        this.columnValueConverter = converter;
        this.objectClass = objectClass;
        this.columnToAccessorMap = columnToAccessorMap;
        Constructor<T> ormConstructor = this.getOrmConstructor(objectClass);
        Constructor<T> ormRecordConstructor = this.getOrmRecordConstructor(objectClass);
        this.containerObjectCreator = ormRecordConstructor != null ? this.createContainerRecordCreator(objectClass, ormRecordConstructor) : (ormConstructor != null ? this.createOrmConstructorPojoCreator(objectClass, ormConstructor) : new SetterBasedSqlResultContainerCreator<T>(columnToAccessorMap, this.getDefaultConstructor(objectClass)));
    }

    private SqlResultContainerCreator<T> createContainerRecordCreator(Class<T> objectClass, Constructor<T> constructor) {
        String[] parameterNames = (String[])Arrays.stream(objectClass.getDeclaredFields()).map(f -> f.getName()).toArray(String[]::new);
        return new ConstructorBasedSqlResultCreator<T>(this.getColumnToAccessorMap(), constructor, parameterNames);
    }

    private Constructor<T> getOrmRecordConstructor(Class<T> objectClass) {
        OrmRecord a = objectClass.getAnnotation(OrmRecord.class);
        if (a == null) {
            return null;
        }
        return Try.getOrElseThrow(() -> objectClass.getConstructor((Class[])Arrays.stream(objectClass.getDeclaredFields()).map(f -> f.getType()).toArray(Class[]::new)), e -> new SormException(ParameterizedStringUtils.newString("The given container class [{}] should have the canonical constructor.", objectClass), (Throwable)e));
    }

    private Constructor<T> getOrmConstructor(Class<T> objectClass) {
        List ormConstructors = Arrays.stream(objectClass.getConstructors()).filter(c -> c.getAnnotation(OrmConstructor.class) != null).collect(Collectors.toList());
        if (ormConstructors.isEmpty()) {
            return null;
        }
        if (ormConstructors.size() > 1) {
            throw new SormException(ParameterizedStringUtils.newString("Constructor with parameters annotated by {} should be one or less. ", OrmConstructor.class.getName()));
        }
        Constructor constructor = (Constructor)ormConstructors.get(0);
        return constructor;
    }

    private SqlResultContainerCreator<T> createOrmConstructorPojoCreator(Class<T> objectClass, Constructor<T> constructor) {
        String[] _parameters = constructor.getAnnotation(OrmConstructor.class).value();
        return new ConstructorBasedSqlResultCreator<T>(this.getColumnToAccessorMap(), constructor, _parameters);
    }

    private Constructor<T> getDefaultConstructor(Class<T> objectClass) {
        return Try.getOrElseThrow(() -> objectClass.getConstructor(new Class[0]), e -> new SormException(ParameterizedStringUtils.newString("The given container class [{}] should have the public default constructor (with no arguments) or the constructor annotated by [{}].", objectClass, OrmConstructor.class.getName()), (Throwable)e));
    }

    public String getFormattedString() {
        return "[" + SqlResultToColumnsMapping.class.getSimpleName() + "] Columns are mappted to a class" + System.lineSeparator() + this.getColumnToAccessorString() + System.lineSeparator() + "  with [" + this.containerObjectCreator + "]";
    }

    public List<T> traverseAndMap(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        String[] columns = this.createColumnLabels(resultSet, metaData);
        String columnsString = this.getObjectColumnsString(columns);
        int[] columnTypes = this.getColumnTypes(resultSet, metaData, columns, columnsString);
        return this.containerObjectCreator.loadContainerObjectList(this.columnValueConverter, resultSet, columns, columnTypes, columnsString);
    }

    public T loadResultContainerObject(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        String[] columns = this.createColumnLabels(resultSet, metaData);
        String columnsString = this.getObjectColumnsString(columns);
        int[] columnTypes = this.getColumnTypes(resultSet, metaData, columns, columnsString);
        return this.containerObjectCreator.loadContainerObject(this.columnValueConverter, resultSet, columns, columnTypes, columnsString);
    }

    public T loadResultContainerObjectByPrimaryKey(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        String[] columns = primaryKeyColumnLabels.computeIfAbsent(objectClass, key -> {
            try {
                return this.createColumnLabels(resultSet, resultSet.getMetaData());
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
        String columnsString = this.getObjectColumnsString(columns);
        int[] columnTypes = this.getColumnTypes(resultSet, null, columns, columnsString);
        return this.containerObjectCreator.loadContainerObject(this.columnValueConverter, resultSet, columns, columnTypes, columnsString);
    }

    private String getObjectColumnsString(String[] columns) {
        return String.join((CharSequence)"-", columns);
    }

    private int[] getColumnTypes(ResultSet resultSet, ResultSetMetaData metaData, String[] columns, String columnsStr) {
        return this.columnTypesMap.computeIfAbsent(columnsStr, k -> {
            try {
                ResultSetMetaData _metaData = metaData == null ? resultSet.getMetaData() : metaData;
                int n = _metaData.getColumnCount();
                int[] ret = new int[n];
                for (int i = 1; i <= ret.length; ++i) {
                    ret[i - 1] = _metaData.getColumnType(i);
                }
                return ret;
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
    }

    private String[] createColumnLabels(ResultSet resultSet, ResultSetMetaData metaData) throws SQLException {
        int colNum = metaData.getColumnCount();
        String[] columns = new String[colNum];
        for (int i = 1; i <= colNum; ++i) {
            columns[i - 1] = metaData.getColumnLabel(i);
        }
        return columns;
    }

    Class<T> getObjectClass() {
        return this.objectClass;
    }

    String getColumnToAccessorString() {
        return "[" + this.objectClass.getName() + "] is mapped to " + this.columnToAccessorMap.toString();
    }

    ColumnToAccessorMapping getColumnToAccessorMap() {
        return this.columnToAccessorMap;
    }
}

