/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.annotation.OrmColumnAliasPrefix;
import org.nkjmlab.sorm4j.result.ColumnNameWithMetaData;
import org.nkjmlab.sorm4j.result.TableMetaData;

public class TableMetaDataImpl
implements TableMetaData {
    private final String tableName;
    private final List<String> columns;
    private final List<String> primaryKeys;
    private final List<String> autoGeneratedColumns;
    private final boolean hasPrimaryKey;
    private final boolean hasAutoGeneratedColumns;
    private final List<String> notAutoGeneratedColumns;
    private final List<String> columnsForUpdate;
    private final String[] autoGeneratedColumnsArray;
    private final List<String> notPrimaryKeys;
    private final String columnAliasPrefix;
    private final String columnsWithAliases;
    private final List<ColumnNameWithMetaData> columnsWithMetaData;

    public TableMetaDataImpl(String tableName, String columnNameAliasPrefix, List<ColumnNameWithMetaData> columnsWithMetaData, List<String> primaryKeys, List<String> autoGeneratedColumns) {
        this.tableName = tableName;
        this.columnsWithMetaData = columnsWithMetaData;
        this.columns = Collections.unmodifiableList(columnsWithMetaData.stream().map(c -> c.getName()).collect(Collectors.toList()));
        this.primaryKeys = Collections.unmodifiableList(primaryKeys);
        this.autoGeneratedColumns = Collections.unmodifiableList(autoGeneratedColumns);
        this.notAutoGeneratedColumns = Collections.unmodifiableList(this.columns.stream().filter(col -> !autoGeneratedColumns.contains(col)).collect(Collectors.toList()));
        this.hasPrimaryKey = !primaryKeys.isEmpty();
        this.hasAutoGeneratedColumns = !autoGeneratedColumns.isEmpty();
        this.autoGeneratedColumnsArray = (String[])autoGeneratedColumns.toArray(String[]::new);
        this.notPrimaryKeys = this.columns.stream().filter(col -> !primaryKeys.contains(col)).collect(Collectors.toList());
        this.columnsForUpdate = Stream.concat(this.notPrimaryKeys.stream(), primaryKeys.stream()).collect(Collectors.toList());
        this.columnAliasPrefix = columnNameAliasPrefix;
        this.columnsWithAliases = String.join((CharSequence)", ", (CharSequence[])this.columns.stream().map(col -> tableName + "." + col + " as " + columnNameAliasPrefix + col).toArray(String[]::new));
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public List<String> getAutoGeneratedColumns() {
        return this.autoGeneratedColumns;
    }

    @Override
    public boolean hasPrimaryKey() {
        return this.hasPrimaryKey;
    }

    @Override
    public boolean hasAutoGeneratedColumns() {
        return this.hasAutoGeneratedColumns;
    }

    @Override
    public List<String> getNotAutoGeneratedColumns() {
        return this.notAutoGeneratedColumns;
    }

    @Override
    public List<String> getColumnsForUpdate() {
        return this.columnsForUpdate;
    }

    @Override
    public String[] getAutoGeneratedColumnsArray() {
        return this.autoGeneratedColumnsArray;
    }

    @Override
    public List<String> getNotPrimaryKeys() {
        return this.notPrimaryKeys;
    }

    @Override
    public String getColumnAliases() {
        return this.columnsWithAliases;
    }

    @Override
    public List<ColumnNameWithMetaData> getColumnsWithMetaData() {
        return this.columnsWithMetaData;
    }

    @Override
    public String getColumnAliasPrefix() {
        return this.columnAliasPrefix;
    }

    public static Optional<String> getColumnAliasPrefix(Class<?> objectClass) {
        return Optional.ofNullable(objectClass.getAnnotation(OrmColumnAliasPrefix.class)).map(a -> a.value());
    }
}

