/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.multirow;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import org.nkjmlab.sorm4j.internal.mapping.SqlParametersToTableMapping;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.mapping.SqlParametersSetter;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;

public final class MultiRowInOneStatementProcessor<T>
extends MultiRowProcessor<T> {
    private final int multiRowSize;

    public MultiRowInOneStatementProcessor(LoggerContext loggerContext, SqlParametersSetter sqlParametersSetter, SqlParametersToTableMapping<T> tableMapping, int batchSize, int multiRowSize) {
        super(loggerContext, sqlParametersSetter, tableMapping, batchSize);
        this.multiRowSize = multiRowSize;
    }

    @Override
    @SafeVarargs
    public final int[] multiRowInsert(Connection con, T ... objects) {
        return this.execMultiRowProcIfValidObjects(con, objects, nonNullObjects -> this.procMultiRowOneStatement(con, num -> con.prepareStatement(this.tableMapping.getSql().getMultirowInsertSql((int)num)), (stmt, objs) -> this.tableMapping.setPrametersOfMultiRow((PreparedStatement)stmt, objs), (T[])nonNullObjects));
    }

    @Override
    @SafeVarargs
    public final int[] multiRowMerge(Connection con, T ... objects) {
        return this.execMultiRowProcIfValidObjects(con, objects, nonNullObjects -> this.procMultiRowOneStatement(con, num -> con.prepareStatement(this.tableMapping.getSql().getMultirowMergeSql((int)num)), (stmt, objs) -> this.tableMapping.setPrametersOfMultiRow((PreparedStatement)stmt, objs), (T[])nonNullObjects));
    }

    private final int[] procMultiRowOneStatement(Connection con, Try.ThrowableFunction<Integer, PreparedStatement> multiRowStatementCreator, Try.ThrowableBiConsumer<PreparedStatement, T[]> parametersSetter, T[] objects) {
        List<T[]> objsPartitions = ArrayUtils.split(this.multiRowSize, objects);
        int[] result = new int[objsPartitions.size()];
        boolean origAutoCommit = MultiRowInOneStatementProcessor.getAutoCommit(con);
        try {
            int[] nArray;
            block19: {
                MultiRowInOneStatementProcessor.setAutoCommit(con, false);
                try (PreparedStatement stmt = multiRowStatementCreator.apply(this.multiRowSize);){
                    int partitionSizeMinusOne = objsPartitions.size() - 1;
                    for (int partitionNum = 0; partitionNum < partitionSizeMinusOne; ++partitionNum) {
                        T[] objectsInOnePartition = objsPartitions.get(partitionNum);
                        parametersSetter.accept(stmt, objectsInOnePartition);
                        result[partitionNum] = stmt.executeUpdate();
                    }
                }
                int lastPartition = objsPartitions.size() - 1;
                T[] objectsInLastPartition = objsPartitions.get(lastPartition);
                PreparedStatement stmt = multiRowStatementCreator.apply(objectsInLastPartition.length);
                try {
                    parametersSetter.accept(stmt, objectsInLastPartition);
                    result[lastPartition] = stmt.executeUpdate();
                    nArray = result;
                    if (stmt == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        MultiRowInOneStatementProcessor.rollbackIfRequired(con, origAutoCommit);
                        throw Try.rethrow(e);
                    }
                }
                stmt.close();
            }
            return nArray;
        }
        finally {
            MultiRowInOneStatementProcessor.commitIfRequired(con, origAutoCommit);
            MultiRowInOneStatementProcessor.setAutoCommit(con, origAutoCommit);
        }
    }
}

