/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.multirow;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Optional;
import java.util.function.Function;
import org.nkjmlab.sorm4j.internal.mapping.SqlParametersToTableMapping;
import org.nkjmlab.sorm4j.internal.mapping.multirow.BatchHelper;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.mapping.SqlParametersSetter;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;

public abstract class MultiRowProcessor<T> {
    private final int batchSize;
    private final SqlParametersSetter sqlParametersSetter;
    final SqlParametersToTableMapping<T> tableMapping;
    final LoggerContext loggerContext;

    MultiRowProcessor(LoggerContext loggerContext, SqlParametersSetter sqlParametersSetter, SqlParametersToTableMapping<T> tableMapping, int batchSize) {
        this.loggerContext = loggerContext;
        this.sqlParametersSetter = sqlParametersSetter;
        this.tableMapping = tableMapping;
        this.batchSize = batchSize;
    }

    public abstract int[] multiRowInsert(Connection var1, T ... var2);

    public abstract int[] multiRowMerge(Connection var1, T ... var2);

    public static final void setAutoCommit(Connection connection, boolean autoCommit) {
        Try.runOrElseThrow(() -> connection.setAutoCommit(autoCommit), Try::rethrow);
    }

    public static final void commitIfRequired(Connection connection, boolean origAutoCommit) {
        if (origAutoCommit) {
            Try.runOrElseThrow(() -> connection.commit(), Try::rethrow);
        }
    }

    public static final void rollbackIfRequired(Connection connection, boolean origAutoCommit) {
        if (!origAutoCommit) {
            Try.runOrElseThrow(() -> connection.rollback(), Try::rethrow);
        }
    }

    public static final boolean getAutoCommit(Connection connection) {
        return Try.createSupplierWithThrow(() -> connection.getAutoCommit(), Try::rethrow).get();
    }

    public final int[] batch(Connection con, String sql, Function<T, Object[]> parameterCreator, T[] objects) {
        return this.execMultiRowProcIfValidObjects(con, objects, nonNullObjects -> {
            int[] result = new int[]{};
            boolean origAutoCommit = MultiRowProcessor.getAutoCommit(con);
            try {
                int[] nArray;
                block12: {
                    PreparedStatement stmt = con.prepareStatement(sql);
                    try {
                        MultiRowProcessor.setAutoCommit(con, false);
                        BatchHelper batchHelper = new BatchHelper(this.batchSize, stmt);
                        for (int i = 0; i < objects.length; ++i) {
                            Object obj = objects[i];
                            this.sqlParametersSetter.setParameters(stmt, (Object[])parameterCreator.apply(obj));
                            batchHelper.addBatchAndExecuteIfReachedThreshold();
                        }
                        nArray = result = batchHelper.finish();
                        if (stmt == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            MultiRowProcessor.rollbackIfRequired(con, origAutoCommit);
                            throw Try.rethrow(e);
                        }
                    }
                    stmt.close();
                }
                return nArray;
            }
            finally {
                MultiRowProcessor.commitIfRequired(con, origAutoCommit);
                MultiRowProcessor.setAutoCommit(con, origAutoCommit);
            }
        });
    }

    final int[] execMultiRowProcIfValidObjects(Connection con, T[] objects, Function<T[], int[]> exec) {
        if (objects == null || objects.length == 0) {
            return new int[0];
        }
        Optional<LoggerContext.LogPoint> lp = this.loggerContext.createLogPoint(LoggerContext.Category.MULTI_ROW, MultiRowProcessor.class);
        lp.ifPresent(_lp -> _lp.logBeforeMultiRow(con, objects[0].getClass(), objects.length, this.tableMapping.getTableMetaData().getTableName()));
        int[] result = exec.apply(objects);
        lp.ifPresent(_lp -> _lp.logAfterMultiRow(result));
        return result;
    }
}

