/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql.result;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.mapping.ResultSetTraverser;
import org.nkjmlab.sorm4j.mapping.RowMapper;
import org.nkjmlab.sorm4j.result.ResultSetStream;

public final class ResultSetStreamImpl<T>
implements ResultSetStream<T> {
    private static final Class<? extends Map> MAP_CLASS = LinkedHashMap.class;
    private final Class<T> objectClass;
    private final OrmConnectionImpl ormMapper;
    private final ResultSet resultSet;
    private final PreparedStatement stmt;

    public ResultSetStreamImpl(OrmConnectionImpl ormMapper, PreparedStatement stmt, ResultSet resultSet) {
        this(ormMapper, MAP_CLASS, stmt, resultSet);
    }

    public ResultSetStreamImpl(OrmConnectionImpl ormMapper, Class<T> objectClass, PreparedStatement stmt, ResultSet resultSet) {
        this.ormMapper = ormMapper;
        this.objectClass = objectClass;
        this.stmt = stmt;
        this.resultSet = resultSet;
    }

    @Override
    public T one() {
        try {
            Map<String, Object> ret = this.objectClass.equals(MAP_CLASS) ? this.ormMapper.loadOneMap(this.resultSet) : this.ormMapper.loadOne(this.objectClass, this.resultSet);
            this.close();
            return (T)ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public T first() {
        try {
            Map<String, Object> ret = this.objectClass.equals(MAP_CLASS) ? this.ormMapper.loadFirstMap(this.resultSet) : this.ormMapper.loadFirst(this.objectClass, this.resultSet);
            this.close();
            return (T)ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public List<T> toList() {
        try {
            List<T> ret = this.objectClass.equals(MAP_CLASS) ? Try.getOrElseThrow(() -> this.ormMapper.traverseAndMapToMapList(this.resultSet), Try::rethrow) : this.ormMapper.loadResultContainerObjectList(this.objectClass, this.resultSet);
            this.close();
            return ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public List<T> toList(RowMapper<T> rowMapper) {
        try {
            List<T> ret = ResultSetTraverser.from(rowMapper).traverseAndMap(this.resultSet);
            this.close();
            return ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ResultSetIterator<T>(this.ormMapper, this.objectClass, this.stmt, this.resultSet);
    }

    @Override
    public Stream<T> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false).onClose(Try.createRunnable(() -> this.close(), Try::rethrow));
    }

    @Override
    public void close() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private final class ResultSetIterator<S>
    implements Iterator<S> {
        private final Supplier<S> nextSupplier;

        public ResultSetIterator(OrmConnectionImpl ormMapper, Class<S> objectClass, PreparedStatement stmt, ResultSet resultSet) {
            this.nextSupplier = objectClass.equals(MAP_CLASS) ? Try.createSupplierWithThrow(() -> ormMapper.mapRowToMap(resultSet), Try::rethrow) : Try.createSupplierWithThrow(() -> ormMapper.mapRowToObject(objectClass, resultSet), Try::rethrow);
        }

        @Override
        public boolean hasNext() {
            try {
                boolean hasNext = ResultSetStreamImpl.this.resultSet.next();
                if (!hasNext) {
                    ResultSetStreamImpl.this.close();
                }
                return hasNext;
            }
            catch (SQLException e) {
                ResultSetStreamImpl.this.close();
                throw Try.rethrow(e);
            }
        }

        @Override
        public S next() {
            return this.nextSupplier.get();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

