/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.mapping.FieldAccessor;

public final class ColumnToAccessorMapping {
    private final Map<String, FieldAccessor> columnToAccessorMap;
    private final Map<String, FieldAccessor> aliasColumnToAccessorMap;
    private final String columnAliasPrefix;

    public ColumnToAccessorMapping(Class<?> objectClass, Map<String, FieldAccessor> columnToAccessorMap, String columnAliasPrefix) {
        this.columnToAccessorMap = columnToAccessorMap.entrySet().stream().collect(Collectors.toMap(e -> StringCache.toCanonicalCase((String)e.getKey()), e -> (FieldAccessor)e.getValue()));
        this.columnAliasPrefix = columnAliasPrefix;
        this.aliasColumnToAccessorMap = columnAliasPrefix == null || columnAliasPrefix.length() == 0 ? Collections.emptyMap() : this.createAliasAccessors(columnAliasPrefix, columnToAccessorMap).entrySet().stream().collect(Collectors.toMap(e -> StringCache.toCanonicalCase((String)e.getKey()), e -> (FieldAccessor)e.getValue()));
    }

    public FieldAccessor get(String columnName) {
        String cn = StringCache.toCanonicalCase(columnName);
        FieldAccessor ret = this.columnToAccessorMap.get(cn);
        return ret != null ? ret : this.aliasColumnToAccessorMap.get(cn);
    }

    public String toString() {
        String keySetString = this.columnToAccessorMap.keySet().stream().sorted().collect(Collectors.toList()).toString();
        return "columns " + keySetString + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), this.columnToAccessorMap.keySet().stream().map(e -> "  Column " + e + " => " + this.columnToAccessorMap.get(e).getFormattedString()).collect(Collectors.toList())) + System.lineSeparator() + "  OrmColumnAliasPrefix is [" + this.columnAliasPrefix + "]" + (this.columnAliasPrefix.length() == 0 ? "" : System.lineSeparator()) + String.join((CharSequence)System.lineSeparator(), this.aliasColumnToAccessorMap.keySet().stream().map(e -> "  Column " + e + " => " + this.aliasColumnToAccessorMap.get(e).getFormattedString()).collect(Collectors.toList()));
    }

    public String getColumnAliasPrefix() {
        return this.columnAliasPrefix;
    }

    public final void setValue(Object object, String columnName, Object value) {
        FieldAccessor acc = this.get(columnName);
        if (acc == null) {
            throw new SormException(ParameterizedStringUtils.newString("Error: setting value [{}] of type [{}] in [{}] because column [{}] does not have a corresponding setter method or field access =>[{}]", value, value.getClass().getSimpleName(), object.getClass().getName(), columnName, this.columnToAccessorMap.toString()));
        }
        try {
            acc.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new SormException(ParameterizedStringUtils.newString("Could not set a value for column [{}] to instance of [{}] with [{}]. The value is=[{}]", columnName, object == null ? "null" : object.getClass().getSimpleName(), acc.getFormattedString(), value), e);
        }
    }

    private final FieldAccessor getAccessor(Object object, String columnName) {
        FieldAccessor acc = this.get(columnName);
        if (acc == null) {
            throw new SormException(ParameterizedStringUtils.newString("Error: getting value from [{}] because column [{}] does not have a corresponding getter method or field access. {}", object.getClass(), columnName, this));
        }
        return acc;
    }

    public final Object getValue(Object object, String columnName) {
        FieldAccessor acc = this.getAccessor(object, columnName);
        try {
            return acc.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new SormException(ParameterizedStringUtils.newString("Could not get a value from instance of [{}] for column [{}] with [{}] The instance is =[{}]", object == null ? "null" : object.getClass().getName(), acc.getFormattedString(), acc.getFormattedString(), object), e);
        }
    }

    public Map<String, FieldAccessor> getAccessors() {
        return this.columnToAccessorMap;
    }

    private Map<String, FieldAccessor> createAliasAccessors(String prefix, Map<String, FieldAccessor> accessors) {
        if (prefix.length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, FieldAccessor> ret = new HashMap<String, FieldAccessor>();
        for (String key : accessors.keySet()) {
            String aKey = StringCache.toCanonicalCase(prefix + key);
            if (accessors.containsKey(aKey)) {
                throw new SormException(ParameterizedStringUtils.newString("Modify table alias because table alias [{}] and column [{}] is concatenated and it becomes duplicated column", prefix, key));
            }
            ret.put(aKey, accessors.get(key));
        }
        return ret;
    }
}

