/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.annotation.OrmColumn;
import org.nkjmlab.sorm4j.annotation.OrmGetter;
import org.nkjmlab.sorm4j.annotation.OrmIgnore;
import org.nkjmlab.sorm4j.annotation.OrmSetter;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.mapping.ColumnToFieldAccessorMapper;
import org.nkjmlab.sorm4j.mapping.FieldAccessor;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;

public final class DefaultColumnToFieldAccessorMapper
implements ColumnToFieldAccessorMapper {
    private final LoggerContext loggerContext;

    public DefaultColumnToFieldAccessorMapper() {
        this(LoggerContext.builder().build());
    }

    public DefaultColumnToFieldAccessorMapper(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
    }

    @Override
    public ColumnToAccessorMapping createMapping(Class<?> objectClass, String columnAliasPrefix) {
        Map<String, FieldAccessor> accessors = this.createAccessors(objectClass);
        return new ColumnToAccessorMapping(objectClass, accessors, columnAliasPrefix);
    }

    private Map<String, Method> extractedMethodStartWith(Class<?> objectClass, String prefix) {
        Class<OrmIgnore> ignoreAnn = OrmIgnore.class;
        return Arrays.stream(objectClass.getMethods()).filter(m -> Objects.isNull(m.getAnnotation(ignoreAnn)) && !Modifier.isStatic(m.getModifiers()) && m.getName().length() > prefix.length() && m.getName().substring(0, prefix.length()).equals(prefix)).collect(Collectors.toMap(m -> StringCache.toCanonicalCase(m.getName().substring(prefix.length())), m -> m, (v1, v2) -> v2));
    }

    private static Map<String, Field> getAllFields(Class<?> objectClass) {
        Class<OrmIgnore> ignoreAnn = OrmIgnore.class;
        return Arrays.stream(objectClass.getFields()).filter(f -> Objects.isNull(f.getAnnotation(ignoreAnn)) && !Modifier.isStatic(f.getModifiers())).collect(Collectors.toMap(f -> StringCache.toCanonicalCase(f.getName()), f -> f));
    }

    private Map<String, Method> getAllGetters(Class<?> objectClass) {
        return this.extractedMethodStartWith(objectClass, "get").entrySet().stream().filter(e -> Objects.nonNull(this.isValidGetter((Method)e.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Method)e.getValue()));
    }

    private Map<String, Method> getAllMethods(Class<?> objectClass) {
        return this.extractedMethodStartWith(objectClass, "").entrySet().stream().filter(e -> Objects.nonNull(this.isValidGetter((Method)e.getValue(), false))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Method)e.getValue()));
    }

    private Map<String, Method> getAllSetters(Class<?> objectClass) {
        return this.extractedMethodStartWith(objectClass, "set").entrySet().stream().filter(e -> Objects.nonNull(this.isValidSetter((Method)e.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Method)e.getValue()));
    }

    private Map<String, Method> getAnnotatatedSettersMap(Class<?> objectClass) {
        Class<OrmSetter> ann = OrmSetter.class;
        return Arrays.stream(objectClass.getMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann)) && Objects.nonNull(this.isValidSetter((Method)m))).collect(Collectors.toMap(m -> StringCache.toCanonicalCase(((OrmSetter)m.getAnnotation(ann)).value()), m -> m));
    }

    private Map<String, Field> getAnnotatedFieldsMap(Class<?> objectClass) {
        Class<OrmColumn> ann = OrmColumn.class;
        return Arrays.stream(objectClass.getFields()).filter(f -> Objects.nonNull(f.getAnnotation(ann))).collect(Collectors.toMap(f -> StringCache.toCanonicalCase(((OrmColumn)f.getAnnotation(ann)).value()), f -> f));
    }

    private Map<String, Method> getAnnotatedGettersMap(Class<?> objectClass) {
        Class<OrmGetter> ann = OrmGetter.class;
        return Arrays.stream(objectClass.getMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann)) && Objects.nonNull(this.isValidGetter((Method)m))).collect(Collectors.toMap(m -> StringCache.toCanonicalCase(((OrmGetter)m.getAnnotation(ann)).value()), m -> m));
    }

    private Method isValidGetter(Method getter) {
        return this.isValidGetter(getter, true);
    }

    private Method isValidGetter(Method getter, boolean logging) {
        if (getter == null) {
            return null;
        }
        if (getter.getName().equals("getClass")) {
            return null;
        }
        if (getter.getParameterCount() != 0) {
            if (logging) {
                this.loggerContext.getLogger(DefaultColumnToFieldAccessorMapper.class).warn("Getter [{}] should not have parameter but has {} params.", getter, getter.getParameterCount());
            }
            return null;
        }
        if (getter.getReturnType() == Void.TYPE && logging) {
            this.loggerContext.getLogger(DefaultColumnToFieldAccessorMapper.class).warn("Getter [{}] must have return a parameter.", getter);
        }
        return getter;
    }

    private Method isValidSetter(Method setter) {
        if (setter == null) {
            return null;
        }
        if (setter.getParameterCount() != 1) {
            this.loggerContext.getLogger(DefaultColumnToFieldAccessorMapper.class).warn("Setter [{}] should have a single parameter but has {} params.", setter, setter.getParameterCount());
            return null;
        }
        return setter;
    }

    private Map<String, FieldAccessor> createAccessors(Class<?> objectClass) {
        HashSet<String> acceptableColumnNames = new HashSet<String>();
        acceptableColumnNames.addAll(DefaultColumnToFieldAccessorMapper.getAllFields(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAllGetters(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAllSetters(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAllMethods(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAnnotatedFieldsMap(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAnnotatedGettersMap(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAnnotatatedSettersMap(objectClass).keySet());
        return this.createAccessors(objectClass, new ArrayList<String>(acceptableColumnNames));
    }

    private Map<String, FieldAccessor> createAccessors(Class<?> objectClass, List<String> acceptableColumnNames) {
        Map<String, Field> fields = DefaultColumnToFieldAccessorMapper.getAllFields(objectClass);
        Map<String, Method> getters = this.getAllGetters(objectClass);
        Map<String, Method> allMethods = this.getAllMethods(objectClass);
        Map<String, Method> setters = this.getAllSetters(objectClass);
        Map<String, Field> annotatedFields = this.getAnnotatedFieldsMap(objectClass);
        Map<String, Method> annotatedGetters = this.getAnnotatedGettersMap(objectClass);
        Map<String, Method> annotatedSetters = this.getAnnotatatedSettersMap(objectClass);
        HashMap<String, FieldAccessor> ret = new HashMap<String, FieldAccessor>();
        for (String canonicalColName : (String[])acceptableColumnNames.stream().map(col -> StringCache.toCanonicalCase(col)).toArray(String[]::new)) {
            Method s;
            Field f;
            Field field = f = Objects.nonNull(annotatedFields.get(canonicalColName)) ? annotatedFields.get(canonicalColName) : fields.get(canonicalColName);
            Method g = Objects.nonNull(annotatedGetters.get(canonicalColName)) ? annotatedGetters.get(canonicalColName) : (Objects.nonNull(getters.get(canonicalColName)) ? getters.get(canonicalColName) : allMethods.get(canonicalColName));
            Method method = s = Objects.nonNull(annotatedSetters.get(canonicalColName)) ? annotatedSetters.get(canonicalColName) : setters.get(canonicalColName);
            if (f == null && g == null && s == null) {
                this.loggerContext.getLogger(DefaultColumnToFieldAccessorMapper.class).debug("Skip matching with ColumnName [{}] to field because could not found corresponding field.", canonicalColName);
                continue;
            }
            ret.put(canonicalColName, new FieldAccessor(canonicalColName, f, g, s));
        }
        return ret;
    }
}

