/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.internal.util.ClassUtils;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.mapping.ColumnValueToJavaObjectConverter;
import org.nkjmlab.sorm4j.mapping.ColumnValueToJavaObjectConverters;

public final class DefaultColumnValueToJavaObjectConverters
implements ColumnValueToJavaObjectConverters {
    private final Map<Class<?>, ColumnValueToJavaObjectConverter<?>> converters;
    private static final Set<Class<?>> supportedTypes = Set.of(Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, InputStream.class, Reader.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, String.class, Object.class, BigDecimal.class, Clob.class, Blob.class, Date.class, Time.class, Timestamp.class, Instant.class, LocalDate.class, LocalTime.class, LocalDateTime.class, OffsetTime.class, OffsetDateTime.class, java.util.Date.class, UUID.class, List.class);

    public DefaultColumnValueToJavaObjectConverters() {
        this(Collections.emptyMap());
    }

    public DefaultColumnValueToJavaObjectConverters(Map<Class<?>, ColumnValueToJavaObjectConverter<?>> converters) {
        this.converters = converters;
    }

    @Override
    public <T> T convertTo(ResultSet resultSet, int columnIndex, int columnType, Class<T> toType) throws SQLException {
        return (T)this.convertToHelper(resultSet, columnIndex, columnType, toType);
    }

    private Object convertToHelper(ResultSet resultSet, int columnIndex, int columnType, Class<?> toType) throws SQLException {
        String name;
        ColumnValueToJavaObjectConverter<?> converter = this.converters.get(toType);
        if (converter != null) {
            return converter.convertTo(resultSet, columnIndex, columnType, toType);
        }
        switch (name = toType.getName()) {
            case "boolean": {
                return resultSet.getBoolean(columnIndex);
            }
            case "java.lang.Boolean": {
                boolean ret = resultSet.getBoolean(columnIndex);
                return !ret && resultSet.wasNull() ? null : Boolean.valueOf(ret);
            }
            case "byte": {
                return resultSet.getByte(columnIndex);
            }
            case "java.lang.Byte": {
                byte ret = resultSet.getByte(columnIndex);
                return ret == 0 && resultSet.wasNull() ? null : Byte.valueOf(ret);
            }
            case "short": {
                return resultSet.getShort(columnIndex);
            }
            case "java.lang.Short": {
                short ret = resultSet.getShort(columnIndex);
                return ret == 0 && resultSet.wasNull() ? null : Short.valueOf(ret);
            }
            case "int": {
                return resultSet.getInt(columnIndex);
            }
            case "java.lang.Integer": {
                int ret = resultSet.getInt(columnIndex);
                return ret == 0 && resultSet.wasNull() ? null : Integer.valueOf(ret);
            }
            case "long": {
                return resultSet.getLong(columnIndex);
            }
            case "java.lang.Long": {
                long ret = resultSet.getLong(columnIndex);
                return ret == 0L && resultSet.wasNull() ? null : Long.valueOf(ret);
            }
            case "float": {
                return Float.valueOf(resultSet.getFloat(columnIndex));
            }
            case "java.lang.Float": {
                float ret = resultSet.getFloat(columnIndex);
                return ret == 0.0f && resultSet.wasNull() ? null : Float.valueOf(ret);
            }
            case "double": {
                return resultSet.getDouble(columnIndex);
            }
            case "java.lang.Double": {
                double ret = resultSet.getDouble(columnIndex);
                return ret == 0.0 && resultSet.wasNull() ? null : Double.valueOf(ret);
            }
            case "java.lang.String": {
                return resultSet.getString(columnIndex);
            }
            case "java.lang.Character": 
            case "char": {
                String str = resultSet.getString(columnIndex);
                return str == null || str.length() == 0 ? null : Character.valueOf(str.charAt(0));
            }
            case "java.lang.Object": {
                return resultSet.getObject(columnIndex);
            }
            case "java.io.InputStream": {
                return resultSet.getBinaryStream(columnIndex);
            }
            case "java.io.Reader": {
                return resultSet.getCharacterStream(columnIndex);
            }
            case "java.math.BigDecimal": {
                return resultSet.getBigDecimal(columnIndex);
            }
            case "java.sql.Date": {
                return resultSet.getDate(columnIndex);
            }
            case "java.sql.Time": {
                return resultSet.getTime(columnIndex);
            }
            case "java.sql.Timestamp": {
                return resultSet.getTimestamp(columnIndex);
            }
            case "java.sql.Blob": {
                return resultSet.getBlob(columnIndex);
            }
            case "java.sql.Clob": {
                return resultSet.getClob(columnIndex);
            }
            case "java.time.Instant": {
                return Optional.ofNullable(resultSet.getTimestamp(columnIndex)).map(t -> t.toInstant()).orElse(null);
            }
            case "java.time.LocalTime": {
                return Optional.ofNullable(resultSet.getTime(columnIndex)).map(t -> t.toLocalTime()).orElse(null);
            }
            case "java.time.LocalDate": {
                return Optional.ofNullable(resultSet.getDate(columnIndex)).map(t -> t.toLocalDate()).orElse(null);
            }
            case "java.time.LocalDateTime": {
                return Optional.ofNullable(resultSet.getTimestamp(columnIndex)).map(t -> t.toLocalDateTime()).orElse(null);
            }
            case "java.util.Date": {
                return Optional.ofNullable(resultSet.getTimestamp(columnIndex)).map(t -> new java.util.Date(t.getTime())).orElse(null);
            }
            case "java.util.UUID": {
                return Optional.ofNullable(resultSet.getString(columnIndex)).map(s -> UUID.fromString(s)).orElse(null);
            }
            case "java.time.OffsetTime": {
                return Optional.ofNullable(resultSet.getObject(columnIndex)).orElse(null);
            }
            case "java.time.OffsetDateTime": {
                return Optional.ofNullable(resultSet.getObject(columnIndex)).orElse(null);
            }
            case "java.util.ArrayList": 
            case "java.util.List": {
                java.sql.Array arry = resultSet.getArray(columnIndex);
                Object srcArry = arry.getArray();
                int length = Array.getLength(srcArry);
                ArrayList<Object> ret = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    ret.add(Array.get(srcArry, i));
                }
                return ret;
            }
        }
        if (toType.isEnum()) {
            try {
                return Enum.valueOf(toType, resultSet.getString(columnIndex));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (toType.isArray()) {
            String compName;
            switch (compName = toType.getComponentType().getName()) {
                case "byte": {
                    return resultSet.getBytes(columnIndex);
                }
            }
            java.sql.Array arry = resultSet.getArray(columnIndex);
            Object srcArry = arry.getArray();
            int length = Array.getLength(srcArry);
            Object destArray = Array.newInstance(ClassUtils.convertToClass(compName), length);
            try {
                for (int i = 0; i < length; ++i) {
                    Object v = Array.get(srcArry, i);
                    Array.set(destArray, i, v);
                }
            }
            catch (Exception e) {
                throw new SormException(ParameterizedStringUtils.newString("Could not convert column ({}) to  array ({}[])", JDBCType.valueOf(columnType).getName(), compName));
            }
            return destArray;
        }
        return resultSet.getObject(columnIndex);
    }

    @Override
    public boolean isSupportedReturnedType(Class<?> objectClass) {
        return supportedTypes.contains(objectClass) || objectClass.isArray();
    }
}

