/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.mapping.SqlParameterSetter;
import org.nkjmlab.sorm4j.mapping.SqlParametersSetter;

public final class DefaultSqlParametersSetter
implements SqlParametersSetter {
    private final Map<Class<?>, SqlParameterSetter> setters;

    public DefaultSqlParametersSetter() {
        this.setters = Collections.emptyMap();
    }

    public DefaultSqlParametersSetter(Map<Class<?>, SqlParameterSetter> setters) {
        this.setters = Map.copyOf(setters);
    }

    @Override
    public void setParameters(PreparedStatement stmt, Object ... parameters) throws SQLException {
        if (parameters == null) {
            return;
        }
        for (int i = 1; i <= parameters.length; ++i) {
            this.setParameter(stmt, i, parameters[i - 1]);
        }
    }

    private void setParameter(PreparedStatement stmt, int parameterIndex, Object parameter) throws SQLException {
        if (parameter == null) {
            stmt.setNull(parameterIndex, 0);
            return;
        }
        Class<?> type = parameter.getClass();
        SqlParameterSetter setter = this.setters.get(type);
        if (setter != null) {
            setter.setParameter(stmt, parameterIndex, parameter);
            return;
        }
        switch (type.getName()) {
            case "java.lang.Boolean": 
            case "boolean": {
                stmt.setBoolean(parameterIndex, (Boolean)parameter);
                return;
            }
            case "java.lang.Byte": 
            case "byte": {
                stmt.setByte(parameterIndex, (Byte)parameter);
                return;
            }
            case "java.lang.Short": 
            case "short": {
                stmt.setShort(parameterIndex, (Short)parameter);
                return;
            }
            case "java.lang.Integer": 
            case "int": {
                stmt.setInt(parameterIndex, (Integer)parameter);
                return;
            }
            case "java.lang.Long": 
            case "long": {
                stmt.setLong(parameterIndex, (Long)parameter);
                return;
            }
            case "java.lang.Float": 
            case "float": {
                stmt.setFloat(parameterIndex, ((Float)parameter).floatValue());
                return;
            }
            case "java.lang.Double": 
            case "double": {
                stmt.setDouble(parameterIndex, (Double)parameter);
                return;
            }
            case "java.lang.Character": 
            case "char": {
                stmt.setString(parameterIndex, parameter == null ? null : "" + (Character)parameter);
                return;
            }
            case "java.lang.String": {
                stmt.setString(parameterIndex, (String)parameter);
                return;
            }
            case "java.math.BigDecimal": {
                stmt.setBigDecimal(parameterIndex, (BigDecimal)parameter);
                return;
            }
            case "java.sql.Date": {
                stmt.setDate(parameterIndex, (Date)parameter);
                return;
            }
            case "java.sql.Time": {
                stmt.setTime(parameterIndex, (Time)parameter);
                return;
            }
            case "java.sql.Timestamp": {
                stmt.setTimestamp(parameterIndex, (Timestamp)parameter);
                return;
            }
            case "java.time.Instant": {
                stmt.setTimestamp(parameterIndex, parameter == null ? null : Timestamp.from((Instant)parameter));
                return;
            }
            case "java.time.LocalTime": {
                stmt.setTime(parameterIndex, parameter == null ? null : Time.valueOf((LocalTime)parameter));
                return;
            }
            case "java.time.LocalDate": {
                stmt.setDate(parameterIndex, parameter == null ? null : Date.valueOf((LocalDate)parameter));
                return;
            }
            case "java.time.LocalDateTime": {
                stmt.setTimestamp(parameterIndex, parameter == null ? null : Timestamp.valueOf((LocalDateTime)parameter));
                return;
            }
            case "java.time.OffsetTime": {
                stmt.setObject(parameterIndex, parameter);
                return;
            }
            case "java.time.OffsetDateTime": {
                stmt.setObject(parameterIndex, parameter);
                return;
            }
            case "java.util.Date": {
                stmt.setTimestamp(parameterIndex, parameter == null ? null : new Timestamp(((java.util.Date)parameter).getTime()));
                return;
            }
            case "java.util.UUID": {
                stmt.setString(parameterIndex, parameter == null ? null : ((UUID)parameter).toString());
                return;
            }
        }
        if (type.isArray()) {
            Class<?> compType = type.getComponentType();
            this.procArray(compType, stmt, parameterIndex, parameter);
        } else if (parameter instanceof List) {
            List list = (List)parameter;
            if (list.isEmpty()) {
                throw new SormException("Size of parameter which type is List should be at least one. ");
            }
            this.procArray(list.get(0).getClass(), stmt, parameterIndex, list.toArray());
        } else if (type.isEnum()) {
            stmt.setString(parameterIndex, parameter.toString());
        } else if (parameter instanceof Blob) {
            stmt.setBlob(parameterIndex, (Blob)parameter);
        } else if (parameter instanceof Clob) {
            stmt.setClob(parameterIndex, (Clob)parameter);
        } else if (parameter instanceof InputStream) {
            InputStream is = (InputStream)parameter;
            stmt.setBinaryStream(parameterIndex, is);
        } else if (parameter instanceof Reader) {
            Reader reader = (Reader)parameter;
            stmt.setCharacterStream(parameterIndex, reader);
        } else {
            stmt.setObject(parameterIndex, parameter);
        }
    }

    private void procArray(Class<?> compType, PreparedStatement stmt, int parameterIndex, Object parameter) throws SQLException {
        String typeName = compType.getName();
        if (typeName.equals("byte")) {
            stmt.setBytes(parameterIndex, (byte[])parameter);
        } else {
            stmt.setArray(parameterIndex, this.toSqlArray(typeName, stmt.getConnection(), parameter));
        }
    }

    private Array toSqlArray(String typeName, Connection conn, Object parameter) throws SQLException {
        switch (typeName) {
            case "boolean": {
                return conn.createArrayOf("BOOLEAN", ArrayUtils.toObjectArray((boolean[])parameter));
            }
            case "java.lang.Boolean": {
                return conn.createArrayOf("BOOLEAN", (Object[])parameter);
            }
            case "java.lang.Byte": {
                return conn.createArrayOf("TINYINT", (Object[])parameter);
            }
            case "short": {
                return conn.createArrayOf("SMALLINT", ArrayUtils.toObjectArray((short[])parameter));
            }
            case "java.lang.Short": {
                return conn.createArrayOf("SMALLINT", (Object[])parameter);
            }
            case "int": {
                return conn.createArrayOf("INTEGER", ArrayUtils.toObjectArray((int[])parameter));
            }
            case "java.lang.Integer": {
                return conn.createArrayOf("INTEGER", (Object[])parameter);
            }
            case "long": {
                return conn.createArrayOf("BINGINT", ArrayUtils.toObjectArray((long[])parameter));
            }
            case "java.lang.Long": {
                return conn.createArrayOf("BIGINT", (Object[])parameter);
            }
            case "float": {
                return conn.createArrayOf("REAL", ArrayUtils.toObjectArray((float[])parameter));
            }
            case "java.lang.Float": {
                return conn.createArrayOf("REAL", (Object[])parameter);
            }
            case "double": {
                return conn.createArrayOf("DOUBLE", ArrayUtils.toObjectArray((double[])parameter));
            }
            case "java.lang.Double": {
                return conn.createArrayOf("DOUBLE", (Object[])parameter);
            }
            case "char": {
                return conn.createArrayOf("CHARACTER", ArrayUtils.toObjectArray((char[])parameter));
            }
            case "java.lang.Character": {
                return conn.createArrayOf("CHARACTER", (Object[])parameter);
            }
            case "java.lang.String": {
                return conn.createArrayOf("VARCHAR", (Object[])parameter);
            }
            case "java.math.BigDecimal": {
                return conn.createArrayOf("NUMERIC", (Object[])parameter);
            }
            case "java.sql.Date": {
                return conn.createArrayOf("DATE", (Object[])parameter);
            }
            case "java.sql.Time": {
                return conn.createArrayOf("TIME", (Object[])parameter);
            }
            case "java.sql.Timestamp": {
                return conn.createArrayOf("TIMESTAMP", (Object[])parameter);
            }
        }
        return conn.createArrayOf("JAVA_OBJECT", (Object[])parameter);
    }
}

