/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.nkjmlab.sorm4j.mapping.TableMetaDataParser;
import org.nkjmlab.sorm4j.result.ColumnName;
import org.nkjmlab.sorm4j.result.ColumnNameWithMetaData;

public final class DefaultTableMetaDataParser
implements TableMetaDataParser {
    @Override
    public List<ColumnName> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), tableName, "%");){
            ArrayList<ColumnName> columnsList = new ArrayList<ColumnName>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                String isAutoIncrement = resultSet.getString(23);
                if (!isAutoIncrement.equals("YES")) continue;
                columnsList.add(new ColumnName(columnName));
            }
            ArrayList<ColumnName> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public List<ColumnNameWithMetaData> getColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), tableName, "%");){
            ArrayList<ColumnNameWithMetaData> columnsList = new ArrayList<ColumnNameWithMetaData>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                int dataType = resultSet.getInt(5);
                String typeName = resultSet.getString(6);
                int ordinalPosition = resultSet.getInt(17);
                String isNullable = resultSet.getString(18);
                String isAutoIncremented = resultSet.getString(23);
                String isGenerated = resultSet.getString(24);
                columnsList.add(new ColumnNameWithMetaData(columnName, dataType, typeName, ordinalPosition, isNullable, isAutoIncremented, isGenerated));
            }
            ArrayList<ColumnNameWithMetaData> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public List<ColumnName> getPrimaryKeys(DatabaseMetaData metaData, String tableName) throws SQLException {
        ArrayList<ColumnName> primaryKeysList = new ArrayList<ColumnName>();
        try (ResultSet resultSet = metaData.getPrimaryKeys(null, this.getSchemaPattern(metaData), tableName);){
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                primaryKeysList.add(new ColumnName(columnName));
            }
            ArrayList<ColumnName> arrayList = primaryKeysList;
            return arrayList;
        }
    }

    private String getSchemaPattern(DatabaseMetaData metaData) throws SQLException {
        return "Oracle".equalsIgnoreCase(metaData.getDatabaseProductName()) ? "%" : null;
    }
}

