/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.annotation.OrmTable;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.mapping.TableName;
import org.nkjmlab.sorm4j.mapping.TableNameMapper;

public final class DefaultTableNameMapper
implements TableNameMapper {
    @Override
    public TableName getTableName(String tableName, DatabaseMetaData metaData) {
        List<String> candidates = List.of(tableName);
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(ParameterizedStringUtils.newString("[{}] does not match any existing table in the database. Use [{}] annotation correctly. Table Name candidates are {}", tableName, OrmTable.class.getName(), candidates)));
    }

    @Override
    public TableName getTableName(Class<?> objectClass, DatabaseMetaData metaData) {
        List<String> candidates = this.guessTableNameCandidates(objectClass);
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(ParameterizedStringUtils.newString("[{}] does not match any existing table in the database. Use [{}] annotation correctly. Table Name candidates are {}", objectClass.getName(), OrmTable.class.getName(), candidates)));
    }

    private List<String> guessTableNameCandidates(Class<?> objectClass) {
        List<String> annotatedTableName = Optional.ofNullable(objectClass.getAnnotation(OrmTable.class)).map(a -> List.of(a.value())).orElse(Collections.emptyList());
        if (!annotatedTableName.isEmpty()) {
            return annotatedTableName;
        }
        String className = objectClass.getSimpleName();
        String cannonicalClassName = StringCache.toCanonicalCase(className);
        return cannonicalClassName.endsWith("Y") ? List.of(cannonicalClassName, cannonicalClassName + "S", cannonicalClassName.substring(0, cannonicalClassName.length() - 1) + "IES") : List.of(cannonicalClassName, cannonicalClassName + "S");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<TableName> convertToExactTableName(DatabaseMetaData metaData, List<String> tableNameCandidates) {
        try (ResultSet resultSet = metaData.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});){
            while (resultSet.next()) {
                String tableNameOnDb = resultSet.getString(3);
                if (!StringCache.containsAsCanonical(tableNameCandidates, tableNameOnDb)) continue;
                Optional<TableName> optional = Optional.of(new TableName(tableNameOnDb));
                return optional;
            }
            Optional<TableName> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

