/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.sql;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.util.sql.SqlKeyword;

@Experimental
public class SelectSql {
    private SelectSql() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static String select(String selectClause) {
        return SelectSql.wrapSpace(SqlKeyword.SELECT + selectClause);
    }

    public static String select(Object ... selectClauses) {
        return SelectSql.wrapSpace(SqlKeyword.SELECT + SelectSql.joinCommaAndSpace(selectClauses));
    }

    public static String selectDistinct(Object ... selectClauses) {
        return SelectSql.wrapSpace(SqlKeyword.SELECT + SqlKeyword.DISTINCT + SelectSql.joinCommaAndSpace(selectClauses));
    }

    public static String selectStarFrom(String tableName) {
        return SqlKeyword.SELECT_STAR + SelectSql.from(tableName);
    }

    public static String as(Object src, String alias) {
        return src + SqlKeyword.AS + alias;
    }

    public static String castAs(String src, String toType) {
        return SelectSql.wrapSpace(SqlKeyword.CAST + SelectSql.wrapParentheses(src + SqlKeyword.AS + toType));
    }

    public static String column(String tableName, String ... colNames) {
        return Arrays.stream(colNames).map(col -> SelectSql.column(tableName, col)).collect(Collectors.joining(", "));
    }

    public static String from(String tableName) {
        return SelectSql.wrapSpace(SqlKeyword.FROM + tableName);
    }

    public static String where() {
        return SelectSql.wrapSpace(SqlKeyword.WHERE);
    }

    public static String where(String searchCondition) {
        return SelectSql.wrapSpace(SqlKeyword.WHERE + searchCondition);
    }

    public static String where(Condition searchCondition) {
        return SelectSql.where(searchCondition.toString());
    }

    public static String op(Object left, String operator, Object right) {
        return SelectSql.wrapParentheses(left + SelectSql.wrapSpace(operator) + right);
    }

    public static Condition cond(String cond) {
        return new Condition(cond);
    }

    public static Condition cond(Object left, String operator, Object right) {
        return new Condition(left, operator, right);
    }

    public static Condition and(Object ... conds) {
        return new Condition("and", conds);
    }

    public static Condition or(Object ... conds) {
        return new Condition("or", conds);
    }

    public static Condition between(Object colName, Object startInclusive, Object endInclusive) {
        return new Condition(colName + SqlKeyword.BETWEEN + SelectSql.literal(startInclusive) + SqlKeyword.AND + SelectSql.literal(endInclusive));
    }

    public static Condition in(Object colName, Object ... values) {
        return new Condition(colName + SqlKeyword.IN + SelectSql.wrapParentheses(SelectSql.joinComma(Arrays.stream(values).map(o -> SelectSql.literal(o)).collect(Collectors.toList()))));
    }

    public static String groupBy(Object ... groups) {
        return SelectSql.wrapSpace(SqlKeyword.GROUP_BY + SelectSql.joinCommaAndSpace(groups));
    }

    public static String limit(Object limit) {
        return SelectSql.wrapSpace(SqlKeyword.LIMIT + limit);
    }

    public static String orderBy(Object ... order) {
        return SqlKeyword.ORDER_BY + SelectSql.joinSpace(order);
    }

    public static String orderBy(Object column) {
        return SelectSql.orderBy(column, SqlKeyword.ASC);
    }

    public static String orderByAsc(Object column) {
        return SelectSql.orderBy(SqlKeyword.ORDER_BY, SqlKeyword.ASC);
    }

    public static String orderByDesc(Object column) {
        return SelectSql.orderBy(SqlKeyword.ORDER_BY, SqlKeyword.DESC);
    }

    public static String func(String functionName, Object args) {
        return SelectSql.wrapSpace(functionName + SelectSql.wrapParentheses(args));
    }

    public static String func(String functionName, Object ... args) {
        return SelectSql.wrapSpace(functionName + SelectSql.wrapParentheses(SelectSql.joinCommaAndSpace(args)));
    }

    public static String count(String column) {
        return SelectSql.func(SqlKeyword.COUNT, (Object)column);
    }

    public static String sum(String column) {
        return SelectSql.func(SqlKeyword.SUM, (Object)column);
    }

    public static String avg(String column) {
        return SelectSql.func(SqlKeyword.AVG, (Object)column);
    }

    public static String literal(Object element) {
        if (element == null) {
            return "null";
        }
        if (element.getClass().isArray()) {
            int length = Array.getLength(element);
            ArrayList<String> ret = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                ret.add(SelectSql.literal(Array.get(element, i)));
            }
            return "[" + String.join((CharSequence)",", ret) + "]";
        }
        if (element instanceof List) {
            return String.join((CharSequence)", ", (CharSequence[])((List)element).stream().map(e -> SelectSql.literal(e)).toArray(String[]::new));
        }
        String str = element.toString();
        if (element instanceof Number || element instanceof Boolean) {
            return str;
        }
        switch (str) {
            case "?": {
                return str;
            }
        }
        return SelectSql.quote(str);
    }

    public static String quote(String str) {
        return SelectSql.wrapSingleQuote(str.contains("'") ? str.replaceAll("'", "''") : str);
    }

    public static String joinCommaAndSpace(Object ... elements) {
        return SelectSql.joinObjects(", ", elements);
    }

    public static String joinComma(Object ... elements) {
        return SelectSql.joinObjects(",", elements);
    }

    public static String joinSpace(Object ... elements) {
        return SelectSql.joinObjects(" ", elements);
    }

    public static String joinObjects(String delimiter, Object ... elements) {
        return String.join((CharSequence)delimiter, (CharSequence[])Arrays.stream(elements).map(o -> o.toString()).toArray(String[]::new));
    }

    public static String wrapParentheses(Object str) {
        return "(" + str + ")";
    }

    public static String wrapSingleQuote(Object str) {
        return "'" + str + "'";
    }

    public static String wrapSpace(Object str) {
        return " " + str + " ";
    }

    public static class Condition {
        private final Object condition;

        private Condition(Object expr) {
            this.condition = expr;
        }

        private Condition(String op, Object ... conds) {
            this(SelectSql.wrapParentheses(SelectSql.joinObjects(SelectSql.wrapSpace(op), conds)));
        }

        private Condition(Object left, String op, Object right) {
            this.condition = left + " " + op.trim() + " " + right;
        }

        public String toString() {
            return this.condition.toString();
        }
    }

    public static class Builder {
        private String columns = "*";
        private boolean distinct;
        private String groupBy;
        private String having;
        private String limit;
        private String orderBy;
        private String table;
        private String where;

        private Builder() {
        }

        public String build() {
            return this.toPrettyString(false);
        }

        public Builder distinct() {
            this.distinct = true;
            return this;
        }

        public Builder from(String table) {
            this.table = table;
            return this;
        }

        public Builder groupBy(String ... columns) {
            this.groupBy = String.join((CharSequence)",", Arrays.stream(columns).collect(Collectors.toList()));
            return this;
        }

        public Builder having(Condition condition) {
            this.having(condition.toString());
            return this;
        }

        public Builder having(String expr) {
            this.having = expr;
            return this;
        }

        public Builder limit(int limit) {
            return this.limit(limit, 0);
        }

        public Builder limit(int limit, int offset) {
            this.limit = limit + (String)(offset > 0 ? " offset " + offset : "");
            return this;
        }

        public Builder orderBy(String ... order) {
            this.orderBy = String.join((CharSequence)" ", order);
            return this;
        }

        public Builder select(String ... columns) {
            this.columns = String.join((CharSequence)", ", Arrays.stream(columns).collect(Collectors.toList()));
            return this;
        }

        public String toPrettyString() {
            return this.toPrettyString(true);
        }

        public String toPrettyString(boolean prettyPrint) {
            StringBuilder sql = new StringBuilder("select ");
            if (this.distinct) {
                sql.append("distinct ");
            }
            sql.append(this.columns);
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(SqlKeyword.FROM + this.table);
            if (this.where != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.WHERE + this.where);
            }
            if (this.groupBy != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.GROUP_BY + this.groupBy);
            }
            if (this.having != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.HAVING + this.having);
            }
            if (this.orderBy != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.ORDER_BY + this.orderBy);
            }
            if (this.limit != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.LIMIT + this.limit);
            }
            return sql.toString();
        }

        public String toString() {
            return this.toPrettyString(false);
        }

        public Builder where(Condition condition) {
            this.where(condition.toString());
            return this;
        }

        public Builder where(String expr) {
            this.where = expr;
            return this;
        }
    }
}

