/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nkjmlab.sorm4j.Sorm;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.mapping.ResultSetTraverser;
import org.nkjmlab.sorm4j.mapping.RowMapper;
import org.nkjmlab.sorm4j.result.InsertResult;
import org.nkjmlab.sorm4j.result.TableMetaData;
import org.nkjmlab.sorm4j.result.Tuple2;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;
import org.nkjmlab.sorm4j.util.sql.SelectSql;
import org.nkjmlab.sorm4j.util.sql.SqlKeyword;
import org.nkjmlab.sorm4j.util.table.TableSchema;

@Experimental
public interface Table<T> {
    public TableSchema getTableSchema();

    public Class<T> getValueType();

    public Sorm getSorm();

    default public void createTableAndIndexesIfNotExists() {
        this.getTableSchema().createTableAndIndexesIfNotExists(this.getSorm());
    }

    default public void createTableIfNotExists() {
        this.getTableSchema().createTableAndIndexesIfNotExists(this.getSorm());
    }

    default public void createIndexesIfNotExists() {
        this.getTableSchema().createIndexesIfNotExists(this.getSorm());
    }

    default public void dropTableIfExists() {
        this.getTableSchema().dropTableIfExists(this.getSorm());
    }

    default public List<T> readAll() {
        return this.getSorm().readAll(this.getValueType());
    }

    default public T readByPrimaryKey(Object ... primaryKeyValues) {
        return this.getSorm().readByPrimaryKey(this.getValueType(), primaryKeyValues);
    }

    default public T readFirst(ParameterizedSql sql) {
        return this.getSorm().readFirst(this.getValueType(), sql);
    }

    default public T readFirst(String sql, Object ... parameters) {
        return this.getSorm().readFirst(this.getValueType(), sql, parameters);
    }

    default public List<T> readList(ParameterizedSql sql) {
        return this.getSorm().readList(this.getValueType(), sql);
    }

    default public List<T> readList(String sql, Object ... parameters) {
        return this.getSorm().readList(this.getValueType(), sql, parameters);
    }

    default public T readOne(ParameterizedSql sql) {
        return this.getSorm().readOne(this.getValueType(), sql);
    }

    default public T readOne(String sql, Object ... parameters) {
        return this.getSorm().readOne(this.getValueType(), sql, parameters);
    }

    default public RowMapper<T> getRowMapper() {
        return this.getSorm().getRowMapper(this.getValueType());
    }

    default public ResultSetTraverser<List<T>> getResultSetTraverser() {
        return this.getSorm().getResultSetTraverser(this.getValueType());
    }

    default public boolean exists(T object) {
        return this.getSorm().exists(object);
    }

    default public int[] delete(List<T> objects) {
        return this.getSorm().deleteOn(this.getTableName(), objects);
    }

    default public int delete(T object) {
        return this.getSorm().deleteOn(this.getTableName(), object);
    }

    default public int[] delete(T ... objects) {
        return this.getSorm().deleteOn(this.getTableName(), objects);
    }

    default public int deleteAll() {
        return this.getSorm().deleteAllOn(this.getTableName());
    }

    default public int[] insert(List<T> objects) {
        return this.getSorm().insert(objects);
    }

    default public int insert(T object) {
        return this.getSorm().insert(object);
    }

    default public int[] insert(T ... objects) {
        return this.getSorm().insert(objects);
    }

    default public InsertResult<T> insertAndGet(List<T> objects) {
        return this.getSorm().insertAndGet(objects);
    }

    default public InsertResult<T> insertAndGet(T object) {
        return this.getSorm().insertAndGet(object);
    }

    default public InsertResult<T> insertAndGet(T ... objects) {
        return this.getSorm().insertAndGet(objects);
    }

    default public int[] merge(List<T> objects) {
        return this.getSorm().merge(objects);
    }

    default public int merge(T object) {
        return this.getSorm().merge(object);
    }

    default public int[] merge(T ... objects) {
        return this.getSorm().merge(objects);
    }

    default public int[] update(List<T> objects) {
        return this.getSorm().update(objects);
    }

    default public int update(T object) {
        return this.getSorm().update(object);
    }

    default public int[] update(T ... objects) {
        return this.getSorm().update(objects);
    }

    default public RowMapper<Map<String, Object>> getRowToMapMapper() {
        return this.getSorm().getRowToMapMapper();
    }

    default public ResultSetTraverser<List<Map<String, Object>>> getResultSetToMapTraverser() {
        return this.getSorm().getResultSetToMapTraverser();
    }

    default public Map<String, Object> readMapFirst(ParameterizedSql sql) {
        return this.getSorm().readMapFirst(sql);
    }

    default public Map<String, Object> readMapFirst(String sql, Object ... parameters) {
        return this.getSorm().readMapFirst(sql, parameters);
    }

    default public List<Map<String, Object>> readMapList(ParameterizedSql sql) {
        return this.getSorm().readMapList(sql);
    }

    default public List<Map<String, Object>> readMapList(String sql, Object ... parameters) {
        return this.getSorm().readMapList(sql, parameters);
    }

    default public Map<String, Object> readMapOne(ParameterizedSql sql) {
        return this.getSorm().readMapOne(sql);
    }

    default public Map<String, Object> readMapOne(String sql, Object ... parameters) {
        return this.getSorm().readMapOne(sql, parameters);
    }

    default public String getTableName() {
        return this.getTableSchema().getTableName();
    }

    default public TableMetaData getTableMetaData() {
        return this.getSorm().getTableMetaData(this.getTableName());
    }

    default public <S> S executeQuery(ParameterizedSql sql, ResultSetTraverser<S> traverser) {
        return this.getSorm().executeQuery(sql, traverser);
    }

    default public <S> List<S> executeQuery(ParameterizedSql sql, RowMapper<S> mapper) {
        return this.getSorm().executeQuery(sql, mapper);
    }

    default public int executeUpdate(String sql, Object ... parameters) {
        return this.getSorm().executeUpdate(sql, parameters);
    }

    default public int executeUpdate(ParameterizedSql sql) {
        return this.getSorm().executeUpdate(sql);
    }

    default public List<T> readListAllMatch(Tuple2<?, ?> ... tuppleOfNameAndValue) {
        return this.getSorm().readList(this.getValueType(), this.getAllMatchSql(tuppleOfNameAndValue));
    }

    default public T readFirstAllMatch(Tuple2<?, ?> ... tuppleOfNameAndValue) {
        return this.getSorm().readFirst(this.getValueType(), this.getAllMatchSql(tuppleOfNameAndValue));
    }

    default public T readOneAllMatch(Tuple2<?, ?> ... tuppleOfNameAndValue) {
        return this.getSorm().readOne(this.getValueType(), this.getAllMatchSql(tuppleOfNameAndValue));
    }

    default public List<Map<String, Object>> readMapListAllMatch(Tuple2<?, ?> ... tuppleOfNameAndValue) {
        return this.getSorm().readMapList(this.getAllMatchSql(tuppleOfNameAndValue));
    }

    default public Map<String, Object> readMapOneAllMatch(Tuple2<?, ?> ... tuppleOfNameAndValue) {
        return this.getSorm().readMapOne(this.getAllMatchSql(tuppleOfNameAndValue));
    }

    default public Map<String, Object> readMapFirstAllMatch(Tuple2<?, ?> ... tuppleOfNameAndValue) {
        return this.getSorm().readMapOne(this.getAllMatchSql(tuppleOfNameAndValue));
    }

    default public ParameterizedSql getAllMatchSql(Tuple2<?, ?> ... tuppleOfNameAndValue) {
        ArrayList conditions = new ArrayList();
        ArrayList params = new ArrayList();
        Arrays.stream(tuppleOfNameAndValue).forEach(t -> {
            conditions.add(t.getT1() + "=?");
            params.add(t.getT2());
        });
        return ParameterizedSql.of(SelectSql.selectStarFrom(this.getTableSchema().getTableName()) + SqlKeyword.WHERE + String.join((CharSequence)SqlKeyword.AND, conditions), params);
    }

    default public <S> List<Tuple2<T, S>> join(Table<S> other, String onCondition) {
        return this.getSorm().readTupleList(this.getValueType(), other.getValueType(), onCondition, new Object[0]);
    }

    default public <S> List<Tuple2<T, S>> leftJoin(Table<S> other, String onCondition) {
        return this.getSorm().readTupleList(this.getValueType(), other.getValueType(), onCondition, new Object[0]);
    }

    default public String getColumnAliases() {
        return this.getTableMetaData().getColumnAliases();
    }
}

