package org.nkjmlab.sorm4j.mapping;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.UnaryOperator;

public final class DefaultPreparedStatementSupplier implements PreparedStatementSupplier {

  private final UnaryOperator<PreparedStatement> preparedStatementOperator;

  public DefaultPreparedStatementSupplier() {
    this(null);
  }

  public DefaultPreparedStatementSupplier(
      UnaryOperator<PreparedStatement> preparedStatementOperator) {
    this.preparedStatementOperator = preparedStatementOperator;
  }


  @Override
  public PreparedStatement prepareStatement(Connection connection, String sql,
      String[] autoGeneratedColumnsArray) throws SQLException {
    PreparedStatement stmt = connection.prepareStatement(sql, autoGeneratedColumnsArray);
    return preparedStatementOperator == null ? stmt : preparedStatementOperator.apply(stmt);
  }


  @Override
  public PreparedStatement prepareStatement(Connection connection, String sql) throws SQLException {
    PreparedStatement stmt = connection.prepareStatement(sql);
    return preparedStatementOperator == null ? stmt : preparedStatementOperator.apply(stmt);
  }


}
