package org.nkjmlab.sorm4j.mapping;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import org.nkjmlab.sorm4j.result.ColumnName;
import org.nkjmlab.sorm4j.result.ColumnNameWithMetaData;

public interface TableMetaDataParser {
  /**
   *
   * Retrieves a list of auto-generated columns of the given table name from the database metadata.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */
  List<ColumnName> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName)
      throws SQLException;

  /**
   * Gets column names of the given table name of the database metadata.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */
  List<ColumnNameWithMetaData> getColumns(DatabaseMetaData metaData, String tableName)
      throws SQLException;

  /**
   *
   * Retrieves a list of primary keys columns of the given table name from the database metadata.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */

  List<ColumnName> getPrimaryKeys(DatabaseMetaData metaData, String tableName) throws SQLException;

}
