/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.context.FieldAccessor;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormat;
import org.nkjmlab.sorm4j.internal.util.StringCache;

public final class ColumnToAccessorMapping {
    private final Map<String, FieldAccessor> columnToAccessorMap;
    private final Map<String, FieldAccessor> aliasColumnToAccessorMap;
    private final String columnAliasPrefix;

    public ColumnToAccessorMapping(Class<?> objectClass, Map<String, FieldAccessor> columnToAccessorMap, String columnAliasPrefix) {
        this.columnToAccessorMap = columnToAccessorMap.entrySet().stream().collect(Collectors.toMap(e -> StringCache.toCanonicalCase((String)e.getKey()), e -> (FieldAccessor)e.getValue()));
        this.columnAliasPrefix = columnAliasPrefix;
        this.aliasColumnToAccessorMap = columnAliasPrefix == null || columnAliasPrefix.length() == 0 ? Collections.emptyMap() : this.createAliasAccessors(columnAliasPrefix, columnToAccessorMap).entrySet().stream().collect(Collectors.toMap(e -> StringCache.toCanonicalCase((String)e.getKey()), e -> (FieldAccessor)e.getValue()));
    }

    public FieldAccessor get(String columnName) {
        String cn = StringCache.toCanonicalCase(columnName);
        FieldAccessor ret = this.columnToAccessorMap.get(cn);
        return ret != null ? ret : this.aliasColumnToAccessorMap.get(cn);
    }

    public String toString() {
        List keySet = this.columnToAccessorMap.keySet().stream().sorted().collect(Collectors.toList());
        List aliasKeySet = this.aliasColumnToAccessorMap.keySet().stream().sorted().collect(Collectors.toList());
        return "columns " + keySet + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), keySet.stream().map(e -> "  CsvColumn " + e + " <=> " + this.columnToAccessorMap.get(e).getFormattedString()).collect(Collectors.toList())) + System.lineSeparator() + "column aliases " + aliasKeySet + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), aliasKeySet.stream().map(e -> "  CsvColumn " + e + " <=> " + this.aliasColumnToAccessorMap.get(e).getFormattedString()).collect(Collectors.toList()));
    }

    public String getColumnAliasPrefix() {
        return this.columnAliasPrefix;
    }

    public final void setValue(Object object, String columnName, Object value) {
        FieldAccessor acc = this.get(columnName);
        if (acc == null) {
            Object[] params = new Object[]{value, value.getClass().getSimpleName(), object.getClass().getName(), columnName, this.columnToAccessorMap.toString()};
            throw new SormException(ParameterizedStringFormat.DEFAULT.format("Error: setting value [{}] of type [{}] in [{}] because column [{}] does not have a corresponding setter method or field access =>[{}]", params));
        }
        try {
            acc.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Object[] params = new Object[]{columnName, object == null ? "null" : object.getClass().getSimpleName(), acc.getFormattedString(), value};
            throw new SormException(ParameterizedStringFormat.DEFAULT.format("Could not set a value for column [{}] to instance of [{}] with [{}]. The value is=[{}]", params), e);
        }
    }

    private final FieldAccessor getAccessor(Object object, String columnName) {
        FieldAccessor acc = this.get(columnName);
        if (acc == null) {
            Object[] params = new Object[]{object.getClass(), columnName, this};
            throw new SormException(ParameterizedStringFormat.DEFAULT.format("Error: getting value from [{}] because column [{}] does not have a corresponding getter method or field access. {}", params));
        }
        return acc;
    }

    public final Object getValue(Object object, String columnName) {
        FieldAccessor acc = this.getAccessor(object, columnName);
        try {
            return acc.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Object[] params = new Object[]{object == null ? "null" : object.getClass().getName(), acc.getFormattedString(), acc.getFormattedString(), object};
            throw new SormException(ParameterizedStringFormat.DEFAULT.format("Could not get a value from instance of [{}] for column [{}] with [{}] The instance is =[{}]", params), e);
        }
    }

    public Set<String> keySet() {
        return this.columnToAccessorMap.keySet();
    }

    private Map<String, FieldAccessor> createAliasAccessors(String prefix, Map<String, FieldAccessor> accessors) {
        if (prefix.length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, FieldAccessor> ret = new HashMap<String, FieldAccessor>();
        for (String key : accessors.keySet()) {
            String aKey = StringCache.toCanonicalCase(prefix + key);
            if (accessors.containsKey(aKey)) {
                Object[] params = new Object[]{prefix, key};
                throw new SormException(ParameterizedStringFormat.DEFAULT.format("Modify table alias because table alias [{}] and column [{}] is concatenated and it becomes duplicated column", params));
            }
            ret.put(aKey, accessors.get(key));
        }
        return ret;
    }
}

