/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;

public final class ParameterizedStringFormat {
    private static final String DEFAULT_PLACEHOLDER = "{}";
    public static final ParameterizedStringFormat LENGTH_8 = new ParameterizedStringFormat("{}", 8);
    public static final ParameterizedStringFormat LENGTH_16 = new ParameterizedStringFormat("{}", 16);
    public static final ParameterizedStringFormat LENGTH_32 = new ParameterizedStringFormat("{}", 32);
    public static final ParameterizedStringFormat LENGTH_64 = new ParameterizedStringFormat("{}", 64);
    public static final ParameterizedStringFormat LENGTH_128 = new ParameterizedStringFormat("{}", 128);
    public static final ParameterizedStringFormat LENGTH_256 = new ParameterizedStringFormat("{}", 256);
    public static final ParameterizedStringFormat LENGTH_512 = new ParameterizedStringFormat("{}", 512);
    public static final ParameterizedStringFormat NO_LENGTH_LIMIT = new ParameterizedStringFormat("{}", Integer.MAX_VALUE);
    public static final ParameterizedStringFormat DEFAULT = LENGTH_256;
    private final String placeholder;
    private final int maxLength;

    private ParameterizedStringFormat(int maxLength) {
        this(DEFAULT_PLACEHOLDER, maxLength);
    }

    private ParameterizedStringFormat(String placeholder, int maxLength) {
        this.placeholder = placeholder;
        this.maxLength = maxLength;
    }

    public String format(String msg, Object ... params) {
        return ParameterizedStringFormat.newStringWithPlaceHolder(msg, this.placeholder, this.maxLength, params);
    }

    public String convertToStringWithType(Object ... params) {
        return String.join((CharSequence)", ", (CharSequence[])Stream.of(params).map(p -> ParameterizedStringFormat.toStringWithType(this.maxLength, p)).toArray(String[]::new));
    }

    public String convertToString(Object ... params) {
        return String.join((CharSequence)", ", (CharSequence[])Stream.of(params).map(p -> ParameterizedStringFormat.toString(this.maxLength, p)).toArray(String[]::new));
    }

    private static String newStringWithPlaceHolder(String msg, String placeholder, int maxLength, Object ... params) {
        if (params == null || params.length == 0) {
            return msg;
        }
        return ParameterizedStringFormat.newString(msg, placeholder, params.length, index -> ParameterizedStringFormat.toString(maxLength, params[index]));
    }

    private static String trim(String string, int maxLength) {
        if (string.length() <= maxLength) {
            return string;
        }
        return string.substring(0, maxLength) + "...";
    }

    public static String newString(String msg, String placeholder, int numOfParameter, Function<Integer, String> parameterReplacer) {
        int j;
        StringBuilder sbuf = new StringBuilder(msg.length() + 50);
        int i = 0;
        int placeholderStringLength = placeholder.length();
        for (int p = 0; p < numOfParameter && (j = msg.indexOf(placeholder, i)) != -1; ++p) {
            sbuf.append(msg, i, j);
            sbuf.append(parameterReplacer.apply(p));
            i = j + placeholderStringLength;
        }
        sbuf.append(msg, i, msg.length());
        return sbuf.toString();
    }

    private static String toString(int maxLength, Object param) {
        if (param == null) {
            return "null";
        }
        if (param.getClass().isArray()) {
            String s = Arrays.deepToString(new Object[]{param});
            return ParameterizedStringFormat.trim(s.substring(1, s.length()), maxLength);
        }
        return ParameterizedStringFormat.trim(param.toString(), maxLength);
    }

    private static String toStringWithType(int maxLength, Object param) {
        if (param == null) {
            return "null";
        }
        if (param.getClass().isArray()) {
            String s = Arrays.deepToString(new Object[]{param});
            return "(" + param.getClass().getSimpleName() + ") " + ParameterizedStringFormat.trim(s.substring(1, s.length()), maxLength);
        }
        return "(" + param.getClass().getSimpleName() + ") " + ParameterizedStringFormat.trim(param.toString(), maxLength);
    }
}

