/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util.logger;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormat;
import org.nkjmlab.sorm4j.internal.util.logger.AbstractSormLogger;
import org.nkjmlab.sorm4j.util.logger.SormLogger;

public final class JulSormLogger
extends AbstractSormLogger
implements SormLogger {
    private final Logger logger;
    private static Logger defaultLogger = JulSormLogger.getDefaultLogger();

    public JulSormLogger(Logger logger) {
        this.logger = logger;
    }

    private static Logger getDefaultLogger() {
        Logger logger = Logger.getLogger(JulSormLogger.class.getName());
        logger.setLevel(Level.FINEST);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINEST);
        logger.addHandler(consoleHandler);
        return logger;
    }

    public static SormLogger getLogger() {
        return new JulSormLogger(defaultLogger);
    }

    @Override
    public void trace(String format, Object ... params) {
        this.logger.finer(ParameterizedStringFormat.DEFAULT.format(format, params));
    }

    @Override
    public void debug(String format, Object ... params) {
        this.logger.fine(ParameterizedStringFormat.DEFAULT.format(format, params));
    }

    @Override
    public void info(String format, Object ... params) {
        this.logger.info(ParameterizedStringFormat.DEFAULT.format(format, params));
    }

    @Override
    public void warn(String format, Object ... params) {
        this.logger.warning(ParameterizedStringFormat.DEFAULT.format(format, params));
    }

    @Override
    public void error(String format, Object ... params) {
        this.logger.severe(ParameterizedStringFormat.DEFAULT.format(format, params));
    }

    @Override
    public void trace(int depth, String format, Object ... params) {
        this.trace(format, params);
    }

    @Override
    public void debug(int depth, String format, Object ... params) {
        this.debug(format, params);
    }

    @Override
    public void info(int depth, String format, Object ... params) {
        this.info(format, params);
    }

    @Override
    public void warn(int depth, String format, Object ... params) {
        this.warn(format, params);
    }

    @Override
    public void error(int depth, String format, Object ... params) {
        this.error(format, params);
    }
}

