/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.logger;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.nkjmlab.sorm4j.internal.util.logger.JulSormLogger;
import org.nkjmlab.sorm4j.internal.util.logger.Log4jSormLogger;
import org.nkjmlab.sorm4j.internal.util.logger.Slf4jSormLogger;
import org.nkjmlab.sorm4j.util.logger.LogPoint;
import org.nkjmlab.sorm4j.util.logger.SormLogger;

public final class LoggerContext {
    private final Set<Category> enabledCategories;
    private final Supplier<SormLogger> loggerSupplier;
    private final Map<Class<?>, SormLogger> loggers = new ConcurrentHashMap();

    public static Builder builder() {
        return new Builder();
    }

    private LoggerContext(Supplier<SormLogger> loggerSupplier, Set<Category> enabledCategories) {
        this.loggerSupplier = loggerSupplier;
        this.enabledCategories = enabledCategories.size() == 0 ? Collections.emptySet() : EnumSet.copyOf(enabledCategories);
    }

    public Optional<LogPoint> createLogPoint(Category category, Class<?> callerClass) {
        return this.isEnable(category) ? Optional.of(new LogPoint(category.name(), this.getLogger(callerClass))) : Optional.empty();
    }

    public SormLogger getLogger(Class<?> clazz) {
        return this.loggers.computeIfAbsent(clazz, k -> this.loggerSupplier.get());
    }

    public boolean isEnable(Category category) {
        return this.enabledCategories.contains((Object)category);
    }

    public String toString() {
        return "LoggerContext [enabledCategories=" + this.enabledCategories + ", logger=" + this.getLogger(LoggerContext.class) + "]";
    }

    public static Supplier<SormLogger> getDefaultLoggerSupplier() {
        return Log4jSormLogger.enableLogger ? Log4jSormLogger::getLogger : (Slf4jSormLogger.enableLogger ? Slf4jSormLogger::getLogger : JulSormLogger::getLogger);
    }

    public static class Builder {
        private Supplier<SormLogger> loggerSupplier;
        private final Set<Category> onCategories = new HashSet<Category>();

        private Builder() {
        }

        public LoggerContext build() {
            this.loggerSupplier = this.loggerSupplier != null ? this.loggerSupplier : LoggerContext.getDefaultLoggerSupplier();
            return new LoggerContext(this.loggerSupplier, this.onCategories);
        }

        public Builder disable(Category ... categories) {
            Arrays.stream(categories).forEach(name -> this.onCategories.remove(name));
            return this;
        }

        public Builder disableAll() {
            this.disable(Category.values());
            return this;
        }

        public Builder enable(Category ... categories) {
            Arrays.stream(categories).forEach(name -> this.onCategories.add((Category)((Object)name)));
            return this;
        }

        public Builder enableAll() {
            this.enable(Category.values());
            return this;
        }

        public Builder setLoggerSupplier(Supplier<SormLogger> loggerSupplier) {
            this.loggerSupplier = loggerSupplier;
            return this;
        }
    }

    public static enum Category {
        MAPPING,
        EXECUTE_QUERY,
        MULTI_ROW,
        EXECUTE_UPDATE;

    }
}

