/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.sql;

import java.util.ArrayList;
import java.util.List;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.common.TableMetaData;
import org.nkjmlab.sorm4j.table.TableMappedOrm;
import org.nkjmlab.sorm4j.util.sql.SelectSql;

@Experimental
public class JoinSql {
    private JoinSql() {
    }

    @Experimental
    public static Builder builder(TableMappedOrm<?> firstTable) {
        return new Builder(firstTable);
    }

    public static class Builder {
        private final List<String> columns = new ArrayList<String>();
        private final List<String> froms = new ArrayList<String>();
        private boolean distinct;
        private String where;
        private String orderBy;
        private String limit;

        private Builder(TableMappedOrm<?> first) {
            this.columns.addAll(first.getTableMetaData().getColumnAliases());
            this.froms.add(first.getTableName());
        }

        public Builder joinUsing(TableMappedOrm<?> other, String ... columnsForJoin) {
            return this.joinUsing("join", other, columnsForJoin);
        }

        public Builder leftJoinUsing(TableMappedOrm<?> other, String ... columnsForJoin) {
            return this.joinUsing("left join", other, columnsForJoin);
        }

        public Builder joinOn(TableMappedOrm<?> other, String onCondition) {
            return this.joinOn("join", other, onCondition);
        }

        public Builder leftJoinOn(TableMappedOrm<?> other, String onCondition) {
            return this.joinOn("left join", other, onCondition);
        }

        private Builder joinUsing(String joinType, TableMappedOrm<?> other, String ... columnsForJoin) {
            return this.join(joinType, other, "using (" + String.join((CharSequence)",", columnsForJoin) + ")");
        }

        private Builder joinOn(String joinType, TableMappedOrm<?> other, String onCondition) {
            return this.join(joinType, other, "on " + onCondition);
        }

        public Builder join(String joinType, TableMappedOrm<?> other, String joinCondition) {
            TableMetaData otherMeta = other.getTableMetaData();
            this.columns.addAll(other.getTableMetaData().getColumnAliases());
            this.froms.add(String.join((CharSequence)" ", joinType, otherMeta.getTableName(), joinCondition));
            return this;
        }

        public Builder where(SelectSql.Condition condition) {
            this.where(condition.toString());
            return this;
        }

        public Builder where(String expr) {
            this.where = expr;
            return this;
        }

        public Builder orderBy(String ... order) {
            this.orderBy = String.join((CharSequence)" ", order);
            return this;
        }

        public Builder limit(int limit) {
            return this.limit(limit, 0);
        }

        public Builder limit(int limit, int offset) {
            this.limit = limit + (String)(offset > 0 ? " offset " + offset : "");
            return this;
        }

        public String build() {
            StringBuilder sql = new StringBuilder("select ");
            if (this.distinct) {
                sql.append("distinct ");
            }
            sql.append(String.join((CharSequence)",", (CharSequence[])this.columns.stream().toArray(String[]::new)) + " ");
            sql.append("from " + String.join((CharSequence)" ", this.froms) + " ");
            if (this.where != null) {
                sql.append("where " + this.where + " ");
            }
            if (this.orderBy != null) {
                sql.append("order by " + this.orderBy + " ");
            }
            if (this.limit != null) {
                sql.append("limit " + this.limit);
            }
            return sql.toString();
        }
    }
}

