/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.sql;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.util.sql.SqlKeyword;

@Experimental
public final class SelectSql {
    private SelectSql() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static String select(String selectClause) {
        return SelectSql.wrapSpace("select " + selectClause);
    }

    public static String select(Object ... selectClauses) {
        return SelectSql.wrapSpace("select " + SelectSql.joinCommaAndSpace(selectClauses));
    }

    public static String selectDistinct(Object ... selectClauses) {
        return SelectSql.wrapSpace("select distinct " + SelectSql.joinCommaAndSpace(selectClauses));
    }

    public static String selectStarFrom(String tableName) {
        return SelectSql.wrapSpace("select *" + SelectSql.from(tableName));
    }

    public static String selectCountFrom(String tableName) {
        return SelectSql.wrapSpace("select count(*)" + SelectSql.from(tableName));
    }

    public static String as(Object src, String alias) {
        return src + SqlKeyword.AS + alias;
    }

    public static String castAs(String src, String toType) {
        return SelectSql.wrapSpace("cast" + SelectSql.wrapParentheses(src + SqlKeyword.AS + toType));
    }

    public static String columnWithTableName(String tableName, String ... colNames) {
        return SelectSql.wrapSpace(Arrays.stream(colNames).map(col -> SelectSql.column(tableName, col)).collect(Collectors.joining(",")));
    }

    public static String column(String tableName, String colName) {
        return SelectSql.wrapSpace(tableName + "." + colName);
    }

    public static String from(String tableName) {
        return SelectSql.wrapSpace("from " + tableName);
    }

    public static String where() {
        return SqlKeyword.WHERE;
    }

    public static String where(String searchCondition) {
        return SelectSql.wrapSpace("where " + searchCondition);
    }

    public static String where(Condition searchCondition) {
        return SelectSql.where(searchCondition.toString());
    }

    public static String op(Object left, String operator, Object right) {
        return SelectSql.wrapParentheses(left + SelectSql.wrapSpace(operator) + right);
    }

    public static Condition cond(String cond) {
        return new Condition(cond);
    }

    public static Condition cond(Object left, String operator, Object right) {
        return new Condition(left, operator, right);
    }

    public static Condition and(Object ... conds) {
        return new Condition("and", conds);
    }

    public static Condition or(Object ... conds) {
        return new Condition("or", conds);
    }

    public static Condition between(Object colName, Object startInclusive, Object endInclusive) {
        return new Condition(SelectSql.wrapSpace(colName + SqlKeyword.BETWEEN + SelectSql.literal(startInclusive) + SqlKeyword.AND + SelectSql.literal(endInclusive)));
    }

    public static Condition in(Object colName, List<?> values) {
        return new Condition(SelectSql.wrapSpace(colName + SqlKeyword.IN + SelectSql.wrapParentheses(SelectSql.literal(values))));
    }

    public static String groupBy(Object ... groups) {
        return SelectSql.wrapSpace("group by " + SelectSql.joinCommaAndSpace(groups));
    }

    public static String limit(Object limit) {
        return SelectSql.wrapSpace("limit " + limit);
    }

    public static String orderBy(Object ... order) {
        return SelectSql.wrapSpace("order by " + SelectSql.joinSpace(order));
    }

    public static String orderBy(Object column) {
        return SelectSql.orderBy(column, "");
    }

    public static String orderByAsc(Object column) {
        return SelectSql.orderBy(column, "asc");
    }

    public static String orderByDesc(Object column) {
        return SelectSql.orderBy(column, "desc");
    }

    public static String func(String functionName, Object args) {
        return SelectSql.wrapSpace(functionName + SelectSql.wrapParentheses(args));
    }

    public static String func(String functionName, Object ... args) {
        return SelectSql.wrapSpace(functionName + SelectSql.wrapParentheses(SelectSql.joinCommaAndSpace(args)));
    }

    public static String count(String column) {
        return SelectSql.func("count", (Object)column);
    }

    public static String sum(String column) {
        return SelectSql.func("sum", (Object)column);
    }

    public static String avg(String column) {
        return SelectSql.func("avg", (Object)column);
    }

    public static String literal(Object element) {
        if (element == null) {
            return "null";
        }
        if (element.getClass().isArray()) {
            int length = Array.getLength(element);
            ArrayList<String> ret = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                ret.add(SelectSql.literal(Array.get(element, i)));
            }
            return "array [" + String.join((CharSequence)", ", ret) + "]";
        }
        if (element instanceof List) {
            return String.join((CharSequence)", ", (CharSequence[])((List)element).stream().map(e -> SelectSql.literal(e)).toArray(String[]::new));
        }
        String str = element.toString();
        if (element instanceof Number || element instanceof Boolean) {
            return str;
        }
        switch (str) {
            case "?": {
                return str;
            }
        }
        return SelectSql.quote(str);
    }

    public static String quote(String str) {
        return SelectSql.wrapSingleQuote(str.contains("'") ? str.replaceAll("'", "''") : str);
    }

    public static String joinCommaAndSpace(String ... elements) {
        return SelectSql.joinObjects(", ", elements);
    }

    public static String joinCommaAndSpace(Object ... elements) {
        return SelectSql.joinObjects(", ", elements);
    }

    public static String joinSpace(Object ... elements) {
        return SelectSql.joinObjects(" ", elements);
    }

    public static String joinObjects(String delimiter, Object ... elements) {
        return String.join((CharSequence)delimiter, (CharSequence[])Arrays.stream(elements).map(o -> o.toString()).toArray(String[]::new));
    }

    public static String wrapParentheses(Object str) {
        return "(" + str + ")";
    }

    public static String wrapSingleQuote(Object str) {
        return "'" + str + "'";
    }

    public static String wrapSpace(Object str) {
        return " " + (str == null ? "null" : str.toString().trim()) + " ";
    }

    public static class Builder {
        private String columns = "*";
        private boolean distinct = false;
        private String from;
        private String where;
        private String groupBy;
        private String orderBy;
        private String having;
        private String limit;

        private Builder() {
        }

        public String build() {
            return this.toString();
        }

        public Builder distinct() {
            this.distinct = true;
            return this;
        }

        public Builder from(String ... tables) {
            this.from = String.join((CharSequence)",", tables);
            return this;
        }

        public Builder groupBy(String ... columns) {
            this.groupBy = String.join((CharSequence)",", Arrays.stream(columns).collect(Collectors.toList()));
            return this;
        }

        public Builder having(Condition condition) {
            this.having(condition.toString());
            return this;
        }

        public Builder having(String expr) {
            this.having = expr;
            return this;
        }

        public Builder limit(int limit) {
            return this.limit(limit, 0);
        }

        public Builder limit(int limit, int offset) {
            this.limit = limit + (String)(offset > 0 ? " offset " + offset : "");
            return this;
        }

        public Builder orderBy(String ... order) {
            this.orderBy = String.join((CharSequence)" ", order);
            return this;
        }

        public Builder select(String ... columns) {
            this.columns = String.join((CharSequence)", ", Arrays.stream(columns).collect(Collectors.toList()));
            return this;
        }

        public String toPrettyString() {
            return this.toPrettyString(true);
        }

        public String toPrettyString(boolean prettyPrint) {
            StringBuilder sql = new StringBuilder("select ");
            if (this.distinct) {
                sql.append("distinct ");
            }
            sql.append(this.columns);
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(SqlKeyword.FROM + this.from);
            if (this.where != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.WHERE + this.where);
            }
            if (this.groupBy != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.GROUP_BY + this.groupBy);
            }
            if (this.having != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.HAVING + this.having);
            }
            if (this.orderBy != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.ORDER_BY + this.orderBy);
            }
            if (this.limit != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.LIMIT + this.limit);
            }
            return sql.toString();
        }

        public String toString() {
            return this.toPrettyString(false);
        }

        public Builder where(Condition condition) {
            this.where(condition.toString());
            return this;
        }

        public Builder where(String expr) {
            this.where = expr;
            return this;
        }
    }

    public static class Condition {
        private final Object condition;

        private Condition(Object expr) {
            this.condition = expr;
        }

        private Condition(String op, Object ... conds) {
            this(SelectSql.wrapParentheses(SelectSql.joinObjects(SelectSql.wrapSpace(op), conds)));
        }

        private Condition(Object left, String op, Object right) {
            this.condition = left + " " + op.trim() + " " + right;
        }

        public String toString() {
            return this.condition.toString();
        }
    }
}

