/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.context;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.annotation.OrmColumn;
import org.nkjmlab.sorm4j.annotation.OrmColumnAliasPrefix;
import org.nkjmlab.sorm4j.annotation.OrmGetter;
import org.nkjmlab.sorm4j.annotation.OrmIgnore;
import org.nkjmlab.sorm4j.annotation.OrmSetter;
import org.nkjmlab.sorm4j.context.ColumnToFieldAccessorMapper;
import org.nkjmlab.sorm4j.context.FieldAccessor;
import org.nkjmlab.sorm4j.internal.util.StringCache;

public final class DefaultColumnToFieldAccessorMapper
implements ColumnToFieldAccessorMapper {
    private static final Set<String> IGNORE_METHODS = Set.of("NOTIFY", "NOTIFYALL", "WAIT", "TOSTRING", "HASHCODE");

    @Override
    public Map<String, FieldAccessor> createMapping(Class<?> objectClass) {
        Set<String> acceptableColumnNames = this.createAcceptableColumnNames(objectClass);
        Map<String, Field> fields = DefaultColumnToFieldAccessorMapper.getAllFields(objectClass);
        Map<String, Method> getters = this.getAllGetters(objectClass);
        Map<String, Method> allMethods = this.getAllMethods(objectClass);
        Map<String, Method> setters = this.getAllSetters(objectClass);
        Map<String, Field> annotatedFields = this.getAnnotatedFieldsMap(objectClass);
        Map<String, Method> annotatedGetters = this.getAnnotatedGettersMap(objectClass);
        Map<String, Method> annotatedSetters = this.getAnnotatatedSettersMap(objectClass);
        HashMap<String, FieldAccessor> ret = new HashMap<String, FieldAccessor>();
        for (String acceptableColName : acceptableColumnNames) {
            Method s;
            Field f;
            Field field = f = Objects.nonNull(annotatedFields.get(acceptableColName)) ? annotatedFields.get(acceptableColName) : fields.get(acceptableColName);
            Method g = Objects.nonNull(annotatedGetters.get(acceptableColName)) ? annotatedGetters.get(acceptableColName) : (Objects.nonNull(getters.get(acceptableColName)) ? getters.get(acceptableColName) : allMethods.get(acceptableColName));
            Method method = s = Objects.nonNull(annotatedSetters.get(acceptableColName)) ? annotatedSetters.get(acceptableColName) : setters.get(acceptableColName);
            if (f == null && g == null && s == null) continue;
            ret.put(acceptableColName, new FieldAccessor(acceptableColName, f, g, s));
        }
        return ret;
    }

    private Map<String, Method> extractedMethodStartWith(Class<?> objectClass, String prefix) {
        Class<OrmIgnore> ignoreAnn = OrmIgnore.class;
        return Arrays.stream(objectClass.getMethods()).filter(m -> Objects.isNull(m.getAnnotation(ignoreAnn)) && !Modifier.isStatic(m.getModifiers()) && m.getName().length() > prefix.length() && m.getName().substring(0, prefix.length()).equals(prefix)).collect(Collectors.toMap(m -> StringCache.toCanonicalCase(m.getName().substring(prefix.length())), m -> m, (v1, v2) -> v2));
    }

    private static Map<String, Field> getAllFields(Class<?> objectClass) {
        Class<OrmIgnore> ignoreAnn = OrmIgnore.class;
        return Arrays.stream(objectClass.getFields()).filter(f -> Objects.isNull(f.getAnnotation(ignoreAnn)) && !Modifier.isStatic(f.getModifiers())).collect(Collectors.toMap(f -> StringCache.toCanonicalCase(f.getName()), f -> f));
    }

    private Map<String, Method> getAllGetters(Class<?> objectClass) {
        return this.extractedMethodStartWith(objectClass, "get").entrySet().stream().filter(e -> Objects.nonNull(this.isValidGetter((Method)e.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Method)e.getValue()));
    }

    private Map<String, Method> getAllMethods(Class<?> objectClass) {
        return this.extractedMethodStartWith(objectClass, "").entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("GET") && Objects.nonNull(this.isValidGetter((Method)e.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Method)e.getValue()));
    }

    private Map<String, Method> getAllSetters(Class<?> objectClass) {
        return this.extractedMethodStartWith(objectClass, "set").entrySet().stream().filter(e -> Objects.nonNull(this.isValidSetter((Method)e.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Method)e.getValue()));
    }

    private Map<String, Method> getAnnotatatedSettersMap(Class<?> objectClass) {
        Class<OrmSetter> ann = OrmSetter.class;
        return Arrays.stream(objectClass.getMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann)) && Objects.nonNull(this.isValidSetter((Method)m))).collect(Collectors.toMap(m -> StringCache.toCanonicalCase(((OrmSetter)m.getAnnotation(ann)).value()), m -> m));
    }

    private Map<String, Field> getAnnotatedFieldsMap(Class<?> objectClass) {
        Class<OrmColumn> ann = OrmColumn.class;
        return Arrays.stream(objectClass.getFields()).filter(f -> Objects.nonNull(f.getAnnotation(ann))).collect(Collectors.toMap(f -> StringCache.toCanonicalCase(((OrmColumn)f.getAnnotation(ann)).value()), f -> f));
    }

    private Map<String, Method> getAnnotatedGettersMap(Class<?> objectClass) {
        Class<OrmGetter> ann = OrmGetter.class;
        return Arrays.stream(objectClass.getMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann)) && Objects.nonNull(this.isValidGetter((Method)m))).collect(Collectors.toMap(m -> StringCache.toCanonicalCase(((OrmGetter)m.getAnnotation(ann)).value()), m -> m));
    }

    private Method isValidGetter(Method getter) {
        return getter == null || getter.getName().equals("getClass") || getter.getParameterCount() != 0 || getter.getReturnType() == Void.TYPE ? null : getter;
    }

    private Method isValidSetter(Method setter) {
        return setter == null || setter.getParameterCount() != 1 ? null : setter;
    }

    private Set<String> createAcceptableColumnNames(Class<?> objectClass) {
        HashSet<String> acceptableColumnNames = new HashSet<String>();
        acceptableColumnNames.addAll(DefaultColumnToFieldAccessorMapper.getAllFields(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAllGetters(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAllSetters(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAllMethods(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAnnotatedFieldsMap(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAnnotatedGettersMap(objectClass).keySet());
        acceptableColumnNames.addAll(this.getAnnotatatedSettersMap(objectClass).keySet());
        acceptableColumnNames.removeAll(IGNORE_METHODS);
        return acceptableColumnNames;
    }

    @Override
    public String getColumnAliasPrefix(Class<?> objectClass) {
        return Optional.ofNullable(objectClass.getAnnotation(OrmColumnAliasPrefix.class)).map(a -> a.value()).orElse(objectClass.getSimpleName() + "DOT");
    }
}

