/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.context;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.nkjmlab.sorm4j.annotation.OrmTable;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.context.TableNameMapper;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.internal.util.StringCache;

public final class DefaultTableNameMapper
implements TableNameMapper {
    private static final String ERROR_MESSAGE = "[{}] does not match any existing table in the database. Use @{} annotation or rename the class. Table name candidates were {}";

    @Override
    public String getTableName(String tableName, DatabaseMetaData metaData) {
        List<String> candidates = List.of(tableName);
        Object[] params = new Object[]{tableName, OrmTable.class.getSimpleName(), candidates};
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(ParameterizedStringFormatter.LENGTH_256.format(ERROR_MESSAGE, params)));
    }

    @Override
    public String getTableName(Class<?> objectClass, DatabaseMetaData metaData) {
        List<String> candidates = this.guessTableNameCandidates(objectClass);
        Object[] params = new Object[]{objectClass.getName(), OrmTable.class.getSimpleName(), candidates};
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(ParameterizedStringFormatter.LENGTH_256.format(ERROR_MESSAGE, params)));
    }

    private List<String> guessTableNameCandidates(Class<?> objectClass) {
        Optional<String> annotatedTableName = Optional.ofNullable(objectClass.getAnnotation(OrmTable.class)).map(a -> a.value());
        if (annotatedTableName.isPresent()) {
            return List.of(annotatedTableName.get());
        }
        String className = objectClass.getSimpleName();
        String cannonicalClassName = StringCache.toCanonicalCase(className);
        ArrayList<String> candidates = new ArrayList<String>(List.of(cannonicalClassName, StringCache.toCanonicalCase(cannonicalClassName + "S"), StringCache.toCanonicalCase(cannonicalClassName + "ES")));
        if (cannonicalClassName.endsWith("Y")) {
            candidates.add(StringCache.toCanonicalCase(cannonicalClassName.substring(0, cannonicalClassName.length() - 1) + "IES"));
        }
        return candidates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> convertToExactTableName(DatabaseMetaData metaData, List<String> tableNameCandidates) {
        try (ResultSet resultSet = metaData.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});){
            while (resultSet.next()) {
                String tableNameOnDb = resultSet.getString(3);
                if (!StringCache.containsAsCanonical(tableNameCandidates, tableNameOnDb)) continue;
                Optional<String> optional = Optional.of(tableNameOnDb);
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

