/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.common.ColumnMetaData;
import org.nkjmlab.sorm4j.common.JdbcTableMetaData;
import org.nkjmlab.sorm4j.context.ColumnToFieldAccessorMapper;
import org.nkjmlab.sorm4j.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.context.ColumnValueToMapValueConverters;
import org.nkjmlab.sorm4j.context.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.context.PreparedStatementSupplier;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.context.SqlParametersSetter;
import org.nkjmlab.sorm4j.context.TableNameMapper;
import org.nkjmlab.sorm4j.context.TableSql;
import org.nkjmlab.sorm4j.context.TableSqlFactory;
import org.nkjmlab.sorm4j.internal.SormConfig;
import org.nkjmlab.sorm4j.internal.common.TableMetaDataImpl;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.internal.mapping.SqlParametersToTableMapping;
import org.nkjmlab.sorm4j.internal.mapping.SqlResultToColumnsMapping;
import org.nkjmlab.sorm4j.internal.mapping.TableName;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.result.JdbcDatabaseMetaData;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;

public final class SormContextImpl
implements SormContext {
    private final ConcurrentMap<String, TableMetaDataImpl> tableMetaDataMap;
    private final ConcurrentMap<String, TableSql> tableSqlMap;
    private final ConcurrentMap<Class<?>, TableName> classNameToValidTableNameMap;
    private final ConcurrentMap<String, TableName> tableNameToValidTableNameMap;
    private final ConcurrentMap<String, SqlParametersToTableMapping<?>> sqlParametersToTableMappings;
    private final ConcurrentMap<Class<?>, SqlResultToColumnsMapping<?>> sqlResultToColumnsMappings;
    private final SormConfig config;

    private SormContextImpl(SormConfig sormConfig) {
        this.config = sormConfig;
        this.tableMetaDataMap = new ConcurrentHashMap<String, TableMetaDataImpl>();
        this.tableSqlMap = new ConcurrentHashMap<String, TableSql>();
        this.classNameToValidTableNameMap = new ConcurrentHashMap();
        this.tableNameToValidTableNameMap = new ConcurrentHashMap<String, TableName>();
        this.sqlParametersToTableMappings = new ConcurrentHashMap();
        this.sqlResultToColumnsMappings = new ConcurrentHashMap();
    }

    public SormContextImpl(LoggerContext loggerContext, ColumnToFieldAccessorMapper columnFieldMapper, TableNameMapper tableNameMapper, ColumnValueToJavaObjectConverters columnValueToJavaObjectConverter, ColumnValueToMapValueConverters columnValueToMapValueConverter, SqlParametersSetter sqlParametersSetter, PreparedStatementSupplier statementSupplier, TableSqlFactory tableSqlFactory, MultiRowProcessorFactory multiRowProcessorFactory) {
        this(new SormConfig(loggerContext, columnFieldMapper, tableNameMapper, columnValueToJavaObjectConverter, columnValueToMapValueConverter, sqlParametersSetter, statementSupplier, tableSqlFactory, multiRowProcessorFactory));
    }

    JdbcTableMetaData getJdbcTableMetaData(Connection connection, String tableName) {
        return this.getTableMetaData(connection, tableName, NoValueType.class);
    }

    <T> TableMetaDataImpl getTableMetaData(Connection connection, String tableName, Class<T> objectClass) {
        TableName _tableName = this.toTableName(connection, tableName);
        TableMetaDataImpl ret = this.tableMetaDataMap.computeIfAbsent(_tableName.getName(), _key -> {
            try {
                return this.createTableMetaData(objectClass, _tableName.getName(), connection.getMetaData());
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
        return ret;
    }

    public <T> TableSql getTableSql(Connection connection, JdbcTableMetaData tableMetaData) {
        return this.tableSqlMap.computeIfAbsent(tableMetaData.getTableName(), _key -> {
            try {
                return this.config.getTableSqlFactory().create(tableMetaData, JdbcDatabaseMetaData.of(connection.getMetaData()));
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
    }

    <T> SqlParametersToTableMapping<T> getTableMapping(Connection connection, Class<T> objectClass) {
        return this.getTableMapping(connection, this.toTableName(connection, objectClass), objectClass);
    }

    <T> SqlParametersToTableMapping<T> getTableMapping(Connection connection, String tableName, Class<T> objectClass) {
        return this.getTableMapping(connection, this.toTableName(connection, tableName), objectClass);
    }

    <T> SqlParametersToTableMapping<T> getTableMapping(Connection connection, TableName tableName, Class<T> objectClass) {
        String key = SormContextImpl.toKey(objectClass, tableName);
        SqlParametersToTableMapping ret = this.sqlParametersToTableMappings.computeIfAbsent(key, _k -> {
            try {
                SqlParametersToTableMapping m = this.createTableMapping(objectClass, tableName.getName(), connection);
                this.config.getLoggerContext().createLogPoint(LoggerContext.Category.MAPPING, SormContext.class).ifPresent(lp -> lp.logMapping(m.toString()));
                return m;
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
        return ret;
    }

    private static String toKey(Class<?> objectClass, TableName tableName) {
        return objectClass.getName() + "-" + tableName.getName();
    }

    <T> SqlResultToColumnsMapping<T> createColumnsMapping(Class<T> objectClass) {
        ColumnToAccessorMapping columnToAccessorMap = new ColumnToAccessorMapping(objectClass, this.config.getColumnToFieldAccessorMapper().createMapping(objectClass), this.config.getColumnToFieldAccessorMapper().getColumnAliasPrefix(objectClass));
        return new SqlResultToColumnsMapping<T>(this.config.getColumnValueToJavaObjectConverter(), objectClass, columnToAccessorMap);
    }

    <T> SqlParametersToTableMapping<T> createTableMapping(Class<T> objectClass, String tableName, Connection connection) throws SQLException {
        ColumnToAccessorMapping columnToAccessorMap = new ColumnToAccessorMapping(objectClass, this.config.getColumnToFieldAccessorMapper().createMapping(objectClass), this.config.getColumnToFieldAccessorMapper().getColumnAliasPrefix(objectClass));
        TableMetaDataImpl tableMetaData = this.getTableMetaData(connection, tableName, objectClass);
        TableSql sql = this.getTableSql(connection, tableMetaData);
        return new SqlParametersToTableMapping<T>(this.config.getLoggerContext(), this.config.getColumnValueToJavaObjectConverter(), this.config.getSqlParametersSetter(), this.config.getPreparedStatementSupplier(), this.config.getMultiRowProcessorFactory(), objectClass, columnToAccessorMap, tableMetaData, sql);
    }

    private <T> TableMetaDataImpl createTableMetaData(Class<T> objectClass, String tableName, DatabaseMetaData metaData) throws SQLException {
        List<ColumnMetaData> columns = this.config.getTableMetaDataReader().getColumnsMetaData(metaData, tableName);
        List<String> primaryKeys = this.config.getTableMetaDataReader().getPrimaryKeys(metaData, tableName);
        List<String> autoGeneratedColumns = this.config.getTableMetaDataReader().getAutoGeneratedColumns(metaData, tableName);
        String prefix = this.config.getColumnToFieldAccessorMapper().getColumnAliasPrefix(objectClass);
        return new TableMetaDataImpl(tableName, prefix, columns, primaryKeys, autoGeneratedColumns);
    }

    <T> SqlParametersToTableMapping<T> getCastedTableMapping(Connection connection, Class<?> objectClass) {
        return this.getTableMapping(connection, objectClass);
    }

    <T> SqlParametersToTableMapping<T> getCastedTableMapping(Connection connection, String tableName, Class<?> objectClass) {
        return this.getTableMapping(connection, tableName, objectClass);
    }

    <T> SqlResultToColumnsMapping<T> getColumnsMapping(Class<T> objectClass) {
        SqlResultToColumnsMapping ret = this.sqlResultToColumnsMappings.computeIfAbsent(objectClass, _k -> {
            SqlResultToColumnsMapping m = this.createColumnsMapping(objectClass);
            this.config.getLoggerContext().createLogPoint(LoggerContext.Category.MAPPING, SormContext.class).ifPresent(lp -> lp.logMapping(m.toString()));
            return m;
        });
        return ret;
    }

    private TableName toTableName(Connection connection, Class<?> objectClass) {
        return this.classNameToValidTableNameMap.computeIfAbsent(objectClass, k -> {
            try {
                return new TableName(this.config.getTableNameMapper().getTableName(objectClass, connection.getMetaData()));
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
    }

    String getTableName(Connection connection, Class<?> objectClass) {
        return this.toTableName(connection, objectClass).getName();
    }

    private TableName toTableName(Connection connection, String tableName) {
        return this.tableNameToValidTableNameMap.computeIfAbsent(tableName, k -> {
            try {
                return new TableName(this.config.getTableNameMapper().getTableName(tableName, connection.getMetaData()));
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
    }

    @Override
    public LoggerContext getLoggerContext() {
        return this.config.getLoggerContext();
    }

    @Override
    public ColumnValueToJavaObjectConverters getColumnValueToJavaObjectConverter() {
        return this.config.getColumnValueToJavaObjectConverter();
    }

    @Override
    public ColumnValueToMapValueConverters getColumnValueToMapValueConverter() {
        return this.config.getColumnValueToMapValueConverter();
    }

    @Override
    public SqlParametersSetter getSqlParametersSetter() {
        return this.config.getSqlParametersSetter();
    }

    @Override
    public PreparedStatementSupplier getPreparedStatementSupplier() {
        return this.config.getPreparedStatementSupplier();
    }

    public String toString() {
        return "SormContext {" + System.lineSeparator() + "[Table metadata]" + System.lineSeparator() + this.convertMapToString(this.tableMetaDataMap) + System.lineSeparator() + "[SqlParameterToTableMappings]" + System.lineSeparator() + this.convertMapToString(this.sqlParametersToTableMappings) + System.lineSeparator() + "[SqlResultToColumnsMapping]" + System.lineSeparator() + this.convertClassMapToString(this.sqlResultToColumnsMappings) + System.lineSeparator() + "[classNameToValidTableNameMap]" + System.lineSeparator() + this.convertClassMapToString(this.classNameToValidTableNameMap) + System.lineSeparator() + "[tableNameToValidTableNameMap]" + System.lineSeparator() + this.convertMapToString(this.tableNameToValidTableNameMap) + System.lineSeparator() + "[SormConfig]" + System.lineSeparator() + this.config + System.lineSeparator() + "}";
    }

    private String convertClassMapToString(Map<Class<?>, ? extends Object> map) {
        return this.convertMapToString(map.entrySet().stream().collect(Collectors.toMap(e -> ((Class)e.getKey()).getName(), e -> e.getValue())));
    }

    private String convertMapToString(Map<String, ? extends Object> map) {
        List keySet = map.keySet().stream().sorted().collect(Collectors.toList());
        return String.join((CharSequence)System.lineSeparator(), keySet.stream().map(e -> e + " => " + map.get(e).toString()).collect(Collectors.toList()));
    }

    @Override
    public SormContext.Builder builder() {
        return SormContext.builder().setColumnToFieldAccessorMapper(this.config.getColumnToFieldAccessorMapper()).setColumnValueToJavaObjectConverters(this.config.getColumnValueToJavaObjectConverter()).setColumnValueToMapValueConverters(this.config.getColumnValueToMapValueConverter()).setLoggerContext(this.config.getLoggerContext()).setMultiRowProcessorFactory(this.config.getMultiRowProcessorFactory()).setPreparedStatementSupplier(this.config.getPreparedStatementSupplier()).setSqlParametersSetter(this.config.getSqlParametersSetter()).setTableNameMapper(this.config.getTableNameMapper()).setTableSqlFactory(this.config.getTableSqlFactory());
    }

    private static class NoValueType {
        private NoValueType() {
        }
    }
}

