/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.annotation.OrmConstructor;
import org.nkjmlab.sorm4j.annotation.OrmRecord;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.internal.mapping.SqlResultToContainerMapping;
import org.nkjmlab.sorm4j.internal.mapping.SqlResultToContainerMappingWithConstructor;
import org.nkjmlab.sorm4j.internal.mapping.SqlResultToContainerMappingWithSetter;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.internal.util.Try;

public final class SqlResultToColumnsMapping<T> {
    private final Class<T> objectClass;
    private final Map<Class<?>, ColumnsAndTypesAndString> metaDataForSelectByPrimaryKey = new ConcurrentHashMap();
    private final ColumnValueToJavaObjectConverters columnValueConverter;
    private final ColumnToAccessorMapping columnToAccessorMap;
    private final SqlResultToContainerMapping<T> containerObjectCreator;

    public SqlResultToColumnsMapping(ColumnValueToJavaObjectConverters converter, Class<T> objectClass, ColumnToAccessorMapping columnToAccessorMap) {
        this.columnValueConverter = converter;
        this.objectClass = objectClass;
        this.columnToAccessorMap = columnToAccessorMap;
        Constructor<T> ormConstructor = this.getOrmConstructor(objectClass);
        Constructor<T> ormRecordConstructor = this.getOrmRecordConstructor(objectClass);
        this.containerObjectCreator = ormRecordConstructor != null ? this.createContainerRecordCreator(objectClass, ormRecordConstructor) : (ormConstructor != null ? this.createOrmConstructorPojoCreator(objectClass, ormConstructor) : new SqlResultToContainerMappingWithSetter<T>(columnToAccessorMap, this.getDefaultConstructor(objectClass)));
    }

    private SqlResultToContainerMapping<T> createContainerRecordCreator(Class<T> objectClass, Constructor<T> constructor) {
        String[] parameterNames = (String[])Arrays.stream(objectClass.getDeclaredFields()).map(f -> f.getName()).toArray(String[]::new);
        return new SqlResultToContainerMappingWithConstructor<T>(this.getColumnToAccessorMap(), constructor, parameterNames);
    }

    private Constructor<T> getOrmRecordConstructor(Class<T> objectClass) {
        OrmRecord a = objectClass.getAnnotation(OrmRecord.class);
        if (a == null) {
            return null;
        }
        Object[] params = new Object[]{objectClass, OrmRecord.class.getSimpleName()};
        return Try.getOrElseThrow(() -> objectClass.getConstructor((Class[])Arrays.stream(objectClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).map(f -> f.getType()).toArray(Class[]::new)), e -> new SormException(ParameterizedStringFormatter.LENGTH_256.format("The given container class [{}] annotated by @{} should have the canonical constructor.", params), (Throwable)e));
    }

    private Constructor<T> getOrmConstructor(Class<T> objectClass) {
        List ormConstructors = Arrays.stream(objectClass.getConstructors()).filter(c -> c.getAnnotation(OrmConstructor.class) != null).collect(Collectors.toList());
        if (ormConstructors.isEmpty()) {
            return null;
        }
        if (ormConstructors.size() > 1) {
            Object[] params = new Object[]{objectClass, OrmConstructor.class.getSimpleName()};
            throw new SormException(ParameterizedStringFormatter.LENGTH_256.format("The given container class [{}] should have one or less constructor annotated by @{}.", params));
        }
        Constructor constructor = (Constructor)ormConstructors.get(0);
        return constructor;
    }

    private SqlResultToContainerMapping<T> createOrmConstructorPojoCreator(Class<T> objectClass, Constructor<T> constructor) {
        String[] _parameters = constructor.getAnnotation(OrmConstructor.class).value();
        return new SqlResultToContainerMappingWithConstructor<T>(this.getColumnToAccessorMap(), constructor, _parameters);
    }

    private Constructor<T> getDefaultConstructor(Class<T> objectClass) {
        Object[] params = new Object[]{objectClass, OrmConstructor.class.getSimpleName(), OrmRecord.class.getSimpleName()};
        return Try.getOrElseThrow(() -> objectClass.getConstructor(new Class[0]), e -> new SormException(ParameterizedStringFormatter.LENGTH_256.format("The given container class [{}] should have the public default constructor or the constructor annotated by @{}. Or the container class should be annotated by @{}.", params), (Throwable)e));
    }

    public List<T> traverseAndMap(ResultSet resultSet) throws SQLException {
        OrmConnectionImpl.ColumnsAndTypes columnsAndTypes = OrmConnectionImpl.ColumnsAndTypes.createColumnsAndTypes(resultSet);
        String columnsString = SqlResultToColumnsMapping.getObjectColumnsString(columnsAndTypes.getColumns());
        return this.containerObjectCreator.loadContainerObjectList(this.columnValueConverter, resultSet, columnsAndTypes.getColumns(), columnsAndTypes.getColumnTypes(), columnsString);
    }

    public T loadResultContainerObject(ResultSet resultSet) throws SQLException {
        OrmConnectionImpl.ColumnsAndTypes columnsAndTypes = OrmConnectionImpl.ColumnsAndTypes.createColumnsAndTypes(resultSet);
        String columnsString = SqlResultToColumnsMapping.getObjectColumnsString(columnsAndTypes.getColumns());
        return this.containerObjectCreator.loadContainerObject(this.columnValueConverter, resultSet, columnsAndTypes.getColumns(), columnsAndTypes.getColumnTypes(), columnsString);
    }

    public T loadResultContainerObjectByPrimaryKey(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        ColumnsAndTypesAndString columnsAndTypesAndString = this.metaDataForSelectByPrimaryKey.computeIfAbsent(objectClass, key -> ColumnsAndTypesAndString.create(resultSet));
        return this.containerObjectCreator.loadContainerObject(this.columnValueConverter, resultSet, columnsAndTypesAndString.columnsAndTypes.getColumns(), columnsAndTypesAndString.columnsAndTypes.getColumnTypes(), columnsAndTypesAndString.columnsString);
    }

    private static String getObjectColumnsString(String[] columns) {
        return String.join((CharSequence)"-", columns);
    }

    ColumnToAccessorMapping getColumnToAccessorMap() {
        return this.columnToAccessorMap;
    }

    public String toString() {
        Object[] params = new Object[]{this.objectClass.getName(), this.containerObjectCreator.getClass().getSimpleName(), this.containerObjectCreator.toString()};
        return ParameterizedStringFormatter.LENGTH_256.format("[{}] instance used as SQL result container will be created by [{}]" + System.lineSeparator() + "{}", params);
    }

    private static class ColumnsAndTypesAndString {
        final OrmConnectionImpl.ColumnsAndTypes columnsAndTypes;
        final String columnsString;

        public ColumnsAndTypesAndString(OrmConnectionImpl.ColumnsAndTypes columnsAndTypes, String columnsString) {
            this.columnsAndTypes = columnsAndTypes;
            this.columnsString = columnsString;
        }

        static ColumnsAndTypesAndString create(ResultSet resultSet) {
            try {
                OrmConnectionImpl.ColumnsAndTypes columnsAndTypes = OrmConnectionImpl.ColumnsAndTypes.createColumnsAndTypes(resultSet);
                String columnsString = SqlResultToColumnsMapping.getObjectColumnsString(columnsAndTypes.getColumns());
                return new ColumnsAndTypesAndString(columnsAndTypes, columnsString);
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        }
    }
}

