/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.server;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.h2.server.web.WebServer;
import org.h2.tools.Server;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;
import org.nkjmlab.sorm4j.util.logger.SormLogger;

@Experimental
public class H2WebBrowsingService {
    private static final SormLogger log = LoggerContext.getDefaultLoggerSupplier().get();
    private final WebServer webServer;

    public H2WebBrowsingService(boolean keepAlive) {
        this.webServer = H2WebBrowsingService.startTemporalWebConsoleServer(keepAlive);
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    private static WebServer startTemporalWebConsoleServer(boolean keepAlive) {
        try {
            String[] stringArray;
            if (keepAlive) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "-webPort";
                stringArray = stringArray2;
                stringArray2[1] = "0";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "-webPort";
                stringArray3[1] = "0";
                stringArray = stringArray3;
                stringArray3[2] = "-webDaemon";
            }
            Server server = Server.createWebServer((String[])stringArray);
            server.start();
            log.info("H2 temporal Web console server started at {}", server.getURL());
            WebServer webServer = (WebServer)server.getService();
            return webServer;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    public void open(Connection conn) {
        try {
            this.webServer.addSession(conn);
            String url = this.webServer.addSession(conn);
            Server.openBrowser((String)url);
            log.info("Web console will be open by web browser = {}", url);
        }
        catch (Exception e) {
            log.error("{}", e.getMessage());
        }
    }

    public void open(DataSource dataSource) {
        Try.runOrElseThrow(() -> this.open(dataSource.getConnection()), Try::rethrow);
    }
}

