/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.util.h2.server.H2ServerProperties;
import org.nkjmlab.sorm4j.util.h2.server.H2ServerPropertiesBuilder;

@Experimental
public class H2WebConsoleServerProperties
extends H2ServerProperties {
    public H2WebConsoleServerProperties(String serverType, int port, String password, String[] args) {
        super(serverType, port, password, args);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends H2ServerPropertiesBuilder<Builder> {
        private static final int DEFAULT_WEBCONSOLE_PORT = 8082;

        public Builder() {
            super("WEB_CONSOLE", 8082, "");
        }

        @Override
        public H2WebConsoleServerProperties build() {
            ArrayList<String> args = new ArrayList<String>(List.of(this.javaCommand, "-cp", this.getH2ClassPath(), "org.h2.tools.Server"));
            args.addAll(List.of("-web", "-webPort", "" + this.port));
            args.addAll(Arrays.asList(this.options));
            args.add("-webAdminPassword");
            args.add(this.password);
            return new H2WebConsoleServerProperties(this.serverType, this.port, this.password, (String[])args.toArray(String[]::new));
        }

        @Override
        public Builder getThisBuilder() {
            return this;
        }
    }
}

