/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.sql;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.util.sql.SelectSql;

@Experimental
public class H2CsvFunctions {
    private H2CsvFunctions() {
    }

    public static String getCallCsvWriteSql(File toFile, String selectSql, Charset charset, char fieldSeparator, Character fieldDelimiter) {
        String _fieldSeparator = H2CsvFunctions.toStringChar(fieldSeparator);
        String csvOptions = SelectSql.literal("charset=" + charset.name()) + H2CsvFunctions.createFiledDelimiter(fieldDelimiter) + H2CsvFunctions.createFieldSepartor(_fieldSeparator);
        String csvStmt = "call csvwrite(" + SelectSql.literal(toFile.getAbsolutePath()) + "," + SelectSql.literal(selectSql) + "," + csvOptions + ")";
        return csvStmt;
    }

    private static String createFieldSepartor(String _fieldSeparator) {
        return "||" + SelectSql.literal(" fieldSeparator=") + "||" + _fieldSeparator;
    }

    private static String createFiledDelimiter(Character fieldDelimiter) {
        return fieldDelimiter != null ? "||" + SelectSql.literal(" fieldDelimiter=") + "||" + H2CsvFunctions.toStringChar(fieldDelimiter.charValue()) : "";
    }

    public static String getCsvReadSql(File csvFile, List<String> csvColumns, Charset charset, char fieldSeparator, Character fieldDelimiter) {
        String _fieldSeparator = H2CsvFunctions.toStringChar(fieldSeparator);
        String csvOptions = SelectSql.literal("charset=" + charset.name()) + (String)(fieldDelimiter != null ? "||" + SelectSql.literal(" fieldDelimiter=") + "||" + H2CsvFunctions.toStringChar(fieldDelimiter.charValue()) : "") + "||" + SelectSql.literal(" fieldSeparator=") + "||" + _fieldSeparator;
        String colSql = csvColumns == null || csvColumns.size() == 0 ? "null" : String.join((CharSequence)("||" + _fieldSeparator + "||"), (CharSequence[])csvColumns.stream().map(col -> SelectSql.literal(col.toUpperCase().replace("`", ""))).toArray(String[]::new));
        String readCsvSql = "csvread(" + SelectSql.literal(csvFile.getAbsolutePath()) + "," + colSql + "," + csvOptions + ")";
        return readCsvSql;
    }

    private static String toStringChar(char fieldSeparator) {
        return "char(" + fieldSeparator + ")";
    }

    public static String getCsvReadAndSelectSql(List<String> selectedColumns, File csvFile, List<String> csvColumns, Charset charset, char fieldSeparator, Character fieldDelimiter) {
        return "select " + (selectedColumns == null || selectedColumns.size() == 0 ? "*" : String.join((CharSequence)",", selectedColumns)) + " from " + H2CsvFunctions.getCsvReadSql(csvFile, csvColumns, charset, fieldSeparator, fieldDelimiter);
    }
}

