/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.context;

import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.context.ColumnValueToMapKeyConverter;
import org.nkjmlab.sorm4j.context.DefaultColumnValueToMapEntryConverter;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.internal.util.StringCache;

public final class DefaultColumnValueToMapKeyConverter
implements ColumnValueToMapKeyConverter {
    @Experimental
    private final DefaultColumnValueToMapEntryConverter.LetterCaseOfKey letterCaseOfKey;

    public DefaultColumnValueToMapKeyConverter(DefaultColumnValueToMapEntryConverter.LetterCaseOfKey letterCaseOfKey) {
        this.letterCaseOfKey = letterCaseOfKey;
    }

    @Override
    public String convertToKey(String columnName) {
        return DefaultColumnValueToMapKeyConverter.convertLetterCase(this.letterCaseOfKey, columnName);
    }

    private static String convertLetterCase(DefaultColumnValueToMapEntryConverter.LetterCaseOfKey letterCaseOfKey, String columnName) {
        switch (letterCaseOfKey) {
            case LOWER_CASE: {
                return StringCache.toLowerCase(columnName);
            }
            case UPPER_CASE: {
                return StringCache.toUpperCase(columnName);
            }
            case CANONICAL_CASE: {
                return StringCache.toCanonicalCase(columnName);
            }
            case NO_CONVERSION: {
                return columnName;
            }
        }
        throw new IllegalArgumentException(ParameterizedStringUtils.newString("{} is invalid", new Object[]{letterCaseOfKey}));
    }
}

