/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.context;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.context.TableSql;
import org.nkjmlab.sorm4j.context.TableSqlFactory;
import org.nkjmlab.sorm4j.result.TableMetaData;

public final class DefaultTableSqlFactory
implements TableSqlFactory {
    @Override
    public TableSql create(TableMetaData tableMetaData) {
        String tableName = tableMetaData.getTableName();
        List<String> columns = tableMetaData.getColumns();
        String selectAllSql = "select " + DefaultTableSqlFactory.joinConnma(columns) + " from " + tableName;
        List<String> notAutoGeneratedColumns = tableMetaData.getNotAutoGeneratedColumns();
        String insertSqlPrefix = "insert into " + tableName + " (" + DefaultTableSqlFactory.joinConnma(notAutoGeneratedColumns) + ") values";
        String insertPlaceholders = " (" + DefaultTableSqlFactory.generatePlaceholders(notAutoGeneratedColumns.size()) + ") ";
        String insertSql = insertSqlPrefix + insertPlaceholders;
        List<String> primaryKeys = tableMetaData.getPrimaryKeys();
        String errorMsg = "This opperation requiers primary key but Table [" + tableName + "] doesn't have it.";
        String existsSql = !tableMetaData.hasPrimaryKey() ? errorMsg : "select 1 from " + tableName + DefaultTableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        String updateSql = !tableMetaData.hasPrimaryKey() ? errorMsg : "update " + tableName + DefaultTableSqlFactory.createUpdateSetClause(tableMetaData.getNotPrimaryKeys()) + DefaultTableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        String deleteSql = !tableMetaData.hasPrimaryKey() ? errorMsg : "delete from " + tableName + DefaultTableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        String mergePlaceholders = " (" + DefaultTableSqlFactory.generatePlaceholders(columns.size()) + ") ";
        String mergeSqlPrefix = !tableMetaData.hasPrimaryKey() ? "" : "merge into " + tableName + " (" + DefaultTableSqlFactory.joinConnma(columns) + ") key (" + String.join((CharSequence)",", primaryKeys) + ") values";
        String mergeSql = !tableMetaData.hasPrimaryKey() ? errorMsg : mergeSqlPrefix + mergePlaceholders;
        String selectByPrimaryKeySql = !tableMetaData.hasPrimaryKey() ? "" : selectAllSql + " " + DefaultTableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        return new TableSql(insertPlaceholders, mergePlaceholders, selectByPrimaryKeySql, selectAllSql, insertSql, updateSql, deleteSql, mergeSql, existsSql, insertSqlPrefix, mergeSqlPrefix);
    }

    private static String joinConnma(List<String> columns) {
        return String.join((CharSequence)", ", columns);
    }

    private static String createUpdateSetClause(List<String> notPrimaryKeys) {
        return " set " + String.join((CharSequence)", ", notPrimaryKeys.stream().map(npk -> npk + "=?").collect(Collectors.toList()));
    }

    private static String createWhereClauseIdentifyByPrimaryKeys(List<String> primaryKeys) {
        return " where " + String.join((CharSequence)" and ", primaryKeys.stream().map(pk -> pk + "=?").collect(Collectors.toList()));
    }

    private static String generatePlaceholders(int num) {
        return String.join((CharSequence)",", Stream.generate(() -> "?").limit(num).collect(Collectors.toList()));
    }
}

