/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.context.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.context.PreparedStatementSupplier;
import org.nkjmlab.sorm4j.context.SqlParametersSetter;
import org.nkjmlab.sorm4j.context.TableSql;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.internal.result.InsertResultImpl;
import org.nkjmlab.sorm4j.internal.result.TableMetaDataImpl;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.result.InsertResult;
import org.nkjmlab.sorm4j.result.TableMetaData;
import org.nkjmlab.sorm4j.util.logger.LogPoint;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;

public final class SqlParametersToTableMapping<T> {
    private final Class<T> objectClass;
    private final ColumnValueToJavaObjectConverters columnValueConverter;
    private final ColumnToAccessorMapping columnToAccessorMap;
    private final PreparedStatementSupplier statementSupplier;
    private final SqlParametersSetter sqlParametersSetter;
    private final MultiRowProcessor<T> multiRowProcessor;
    private final TableMetaDataImpl tableMetaData;
    private final TableSql sql;
    private final LoggerContext loggerContext;

    public SqlParametersToTableMapping(LoggerContext loggerContext, ColumnValueToJavaObjectConverters columnValueConverter, SqlParametersSetter sqlParametersSetter, PreparedStatementSupplier statementSupplier, MultiRowProcessorFactory multiRowProcessorFactory, Class<T> objectClass, ColumnToAccessorMapping columnToAccessorMap, TableMetaDataImpl tableMetaData, TableSql sql) {
        this.columnValueConverter = columnValueConverter;
        this.objectClass = objectClass;
        this.columnToAccessorMap = columnToAccessorMap;
        this.loggerContext = loggerContext;
        this.tableMetaData = tableMetaData;
        this.sql = sql;
        this.sqlParametersSetter = sqlParametersSetter;
        this.statementSupplier = statementSupplier;
        this.multiRowProcessor = multiRowProcessorFactory.getMultiRowProcessor(loggerContext, sqlParametersSetter, statementSupplier, objectClass, this);
    }

    public int[] batch(Connection con, String sql, Function<T, Object[]> parameterCreator, T[] objects) {
        return this.multiRowProcessor.batch(con, sql, parameterCreator, objects);
    }

    ColumnToAccessorMapping getColumnToAccessorMap() {
        return this.columnToAccessorMap;
    }

    public Object[] getDeleteParameters(T object) {
        return this.getParameters(object, this.tableMetaData.getPrimaryKeys());
    }

    public Object[] getInsertParameters(T object) {
        return this.getParametersWithoutAutoGeneratedColumns(object);
    }

    public Object[] getMergeParameters(T object) {
        return this.getParametersWithoutAutoGeneratedColumns(object);
    }

    public Object[] getParameters(Object object, List<String> columns) {
        if (object == null) {
            throw new SormException(ParameterizedStringUtils.newString("Fail to get value from a instance of [{}] but it is null.", this.objectClass));
        }
        Object[] ret = new Object[columns.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.columnToAccessorMap.getValue(object, columns.get(i));
        }
        return ret;
    }

    public Object[] getParametersWithoutAutoGeneratedColumns(T object) {
        return this.getParameters(object, this.tableMetaData.getNotAutoGeneratedColumns());
    }

    public Object[] getPrimaryKeyParameters(T object) {
        return this.getParameters(object, this.tableMetaData.getPrimaryKeys());
    }

    public TableSql getSql() {
        return this.sql;
    }

    public TableMetaData getTableMetaData() {
        return this.tableMetaData;
    }

    public Object[] getUpdateParameters(T object) {
        this.throwExeptionIfPrimaryKeyIsNotExist();
        return this.getParameters(object, this.tableMetaData.getColumnsForUpdate());
    }

    public final int[] insert(Connection con, T[] objects) {
        return this.multiRowProcessor.multiRowInsert(con, objects);
    }

    public InsertResult<T> insertAndGet(Connection connection, T object) {
        InsertResultImpl<T> insertResultImpl;
        block8: {
            String insertSql = this.sql.getInsertSql();
            PreparedStatement stmt = !this.tableMetaData.hasAutoGeneratedColumns() ? this.statementSupplier.prepareStatement(connection, insertSql) : this.statementSupplier.prepareStatement(connection, insertSql, this.tableMetaData.getAutoGeneratedColumnsArray());
            try {
                Object[] parameters = this.getInsertParameters(object);
                this.sqlParametersSetter.setParameters(stmt, parameters);
                Optional<LogPoint> lp = this.loggerContext.createLogPoint(LoggerContext.Category.EXECUTE_UPDATE, SqlParametersToTableMapping.class);
                lp.ifPresent(_lp -> _lp.logBeforeSql(connection, insertSql, parameters));
                int rowsModified = stmt.executeUpdate();
                lp.ifPresent(_lp -> _lp.logAfterUpdate(rowsModified));
                List<Object> keys = this.setAutoGeneratedKeys(stmt, object);
                insertResultImpl = new InsertResultImpl<T>(new int[]{rowsModified}, object, keys);
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            stmt.close();
        }
        return insertResultImpl;
    }

    public final InsertResult<T> insertAndGet(Connection con, T[] objects) {
        T[] objsWithoutLast = Arrays.asList(objects).subList(0, objects.length - 1).toArray(Object[]::new);
        T last = objects[objects.length - 1];
        int[] resultWithoutLast = this.insert(con, objsWithoutLast);
        InsertResult<T> insertResult = this.insertAndGet(con, last);
        int[] result = ArrayUtils.add(resultWithoutLast, insertResult.getRowsModified()[0]);
        return new InsertResultImpl<T>(result, insertResult.getObject(), insertResult.getAutoGeneratedKeys());
    }

    private List<Object> setAutoGeneratedKeys(PreparedStatement stmt, T object) throws SQLException {
        try (ResultSet resultSet = stmt.getGeneratedKeys();){
            ResultSetMetaData metaData = resultSet.getMetaData();
            ArrayList<Object> ret = new ArrayList<Object>();
            while (resultSet.next()) {
                String columnName = metaData.getColumnName(1);
                int columnType = metaData.getColumnType(1);
                try {
                    Class<?> classType = this.columnToAccessorMap.get(columnName).getSetterParameterType();
                    Object value = this.columnValueConverter.convertTo(resultSet, 1, columnType, classType);
                    this.columnToAccessorMap.setValue(object, columnName, value);
                    ret.add(value);
                }
                catch (Exception e) {
                    throw Try.rethrow(new SormException(ParameterizedStringUtils.newString("insert an instance of [{}] and get the result has error because [{}] has invalid setter.", object.getClass(), columnName), e));
                }
            }
            ArrayList<Object> arrayList = ret;
            return arrayList;
        }
    }

    public int[] merge(Connection con, T[] objects) {
        int[] result = this.multiRowProcessor.multiRowMerge(con, objects);
        return result;
    }

    private void throwExeptionIfPrimaryKeyIsNotExist() {
        if (!this.tableMetaData.hasPrimaryKey()) {
            throw new SormException("This opperation requiers primary keys but Table [" + this.tableMetaData.getTableName() + "] doesn't have them.");
        }
    }

    public String toString() {
        return "[" + this.objectClass.getName() + "] class is mapped to [" + this.tableMetaData.getTableName() + "] Table. [" + this.objectClass.getName() + "] could set/get values for following columns." + System.lineSeparator() + this.columnToAccessorMap.toString() + System.lineSeparator() + "  with [" + this.multiRowProcessor.getClass().getSimpleName() + "]";
    }
}

