/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.internal.mapping.SqlResultToContainerMapping;
import org.nkjmlab.sorm4j.internal.util.JdbcTypeUtils;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.internal.util.Try;

final class SqlResultToContainerMappingWithConstructor<S>
extends SqlResultToContainerMapping<S> {
    private final Map<String, ConstructorParameter> constructorParametersMap = new HashMap<String, ConstructorParameter>();
    private final int constructorParametersLength;
    private final Map<String, ConstructorParameter[]> columnAndConstructorParameterMapping = new ConcurrentHashMap<String, ConstructorParameter[]>();

    public SqlResultToContainerMappingWithConstructor(ColumnToAccessorMapping columnToAccessorMap, Constructor<S> constructor, String[] parameterNames) {
        super(columnToAccessorMap, constructor);
        String columnAliasPrefix = columnToAccessorMap.getColumnAliasPrefix();
        Parameter[] parameters = constructor.getParameters();
        this.constructorParametersLength = parameters.length;
        for (int i = 0; i < this.constructorParametersLength; ++i) {
            Parameter parameter = parameters[i];
            String canonicalName = StringCache.toCanonicalCase(parameterNames[i]);
            ConstructorParameter cp = new ConstructorParameter(canonicalName, i, parameter.getType());
            this.constructorParametersMap.put(canonicalName, cp);
            if (columnAliasPrefix == null || columnAliasPrefix.length() == 0) continue;
            this.constructorParametersMap.put(StringCache.toCanonicalCase(columnAliasPrefix + canonicalName), cp);
        }
    }

    private S createContainerObject(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, int[] sqlTypes, ConstructorParameter[] constructorParameters) {
        try {
            Object[] params = new Object[this.constructorParametersLength];
            for (int i = 0; i < constructorParameters.length; ++i) {
                ConstructorParameter cp = constructorParameters[i];
                if (cp == null) continue;
                params[cp.getOrder()] = columnValueConverter.convertTo(resultSet, i + 1, sqlTypes[i], constructorParameters[i].getType());
            }
            return (S)this.constructor.newInstance(params);
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new SormException(ParameterizedStringUtils.newString("Constructor with parameters of container class for object-relation mapping is not match with columns. sqltypes={}, param={}", JdbcTypeUtils.convert(sqlTypes), constructorParameters), e);
        }
    }

    private ConstructorParameter[] getCorrespondingParameter(String[] columns, String objectColumnsStr) {
        return this.columnAndConstructorParameterMapping.computeIfAbsent(objectColumnsStr, key -> (ConstructorParameter[])Arrays.stream(columns).map(col -> this.constructorParametersMap.get(StringCache.toCanonicalCase(col))).toArray(ConstructorParameter[]::new));
    }

    @Override
    List<S> loadContainerObjectList(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, String[] columns, int[] columnTypes, String columnsString) throws SQLException {
        ConstructorParameter[] constructorParameters = this.getCorrespondingParameter(columns, columnsString);
        ArrayList<S> ret = new ArrayList<S>();
        while (resultSet.next()) {
            ret.add(this.createContainerObject(columnValueConverter, resultSet, columnTypes, constructorParameters));
        }
        return ret;
    }

    @Override
    S loadContainerObject(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, String[] columns, int[] columnTypes, String columnsString) throws SQLException {
        ConstructorParameter[] constructorParameters = this.getCorrespondingParameter(columns, columnsString);
        return this.createContainerObject(columnValueConverter, resultSet, columnTypes, constructorParameters);
    }

    @Override
    public String toString() {
        List keySet = this.constructorParametersMap.keySet().stream().sorted().collect(Collectors.toList());
        return ParameterizedStringUtils.newString("constructor=[{}], arguments={}" + System.lineSeparator() + "{}", this.constructor, keySet, String.join((CharSequence)System.lineSeparator(), keySet.stream().map(key -> "  " + key + "=>" + this.constructorParametersMap.get(key)).collect(Collectors.toList())));
    }

    static final class ConstructorParameter {
        private final String name;
        private final int order;
        private final Class<?> type;

        public ConstructorParameter(String name, int order, Class<?> type) {
            this.name = name;
            this.order = order;
            this.type = type;
        }

        public int getOrder() {
            return this.order;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String toString() {
            return "[name=" + this.name + ", order=" + this.order + ", type=" + this.type + "]";
        }
    }
}

