/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.context.FieldAccessor;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.internal.mapping.SqlResultToContainerMapping;
import org.nkjmlab.sorm4j.internal.util.Try;

final class SqlResultToContainerMappingWithSetter<T>
extends SqlResultToContainerMapping<T> {
    private final Map<String, Class<?>[]> setterTypesMap = new ConcurrentHashMap<String, Class<?>[]>();

    public SqlResultToContainerMappingWithSetter(ColumnToAccessorMapping columnToAccessorMap, Constructor<T> constructor) {
        super(columnToAccessorMap, constructor);
    }

    private Class<?>[] getSetterTypes(String[] columns, String objectColumnsStr) {
        return this.setterTypesMap.computeIfAbsent(objectColumnsStr, k -> (Class[])Arrays.stream(columns).map(columnName -> {
            FieldAccessor acc = this.columnToAccessorMap.get((String)columnName);
            return acc != null ? acc.getSetterParameterType() : null;
        }).toArray(Class[]::new));
    }

    @Override
    T loadContainerObject(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, String[] columns, int[] columnTypes, String columnsString) throws SQLException {
        Class<?>[] setterTypes = this.getSetterTypes(columns, columnsString);
        return this.createContainerObject(columnValueConverter, resultSet, columns, columnTypes, setterTypes);
    }

    @Override
    public List<T> loadContainerObjectList(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, String[] columns, int[] columnTypes, String columnsString) throws SQLException {
        Class<?>[] setterTypes = this.getSetterTypes(columns, columnsString);
        ArrayList<T> ret = new ArrayList<T>();
        while (resultSet.next()) {
            ret.add(this.createContainerObject(columnValueConverter, resultSet, columns, columnTypes, setterTypes));
        }
        return ret;
    }

    private T createContainerObject(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, String[] columns, int[] sqlTypes, Class<?>[] setterTypes) {
        try {
            Object ret = this.constructor.newInstance(new Object[0]);
            for (int i = 1; i <= columns.length; ++i) {
                Class<?> setterType;
                String columnName = columns[i - 1];
                if (this.columnToAccessorMap.get(columnName) == null || (setterType = setterTypes[i - 1]) == null) continue;
                int sqlType = sqlTypes[i - 1];
                Object value = columnValueConverter.convertTo(resultSet, i, sqlType, setterType);
                this.columnToAccessorMap.setValue(ret, columnName, value);
            }
            return ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new SormException("Container class for object relation mapping must have the public default constructor (with no arguments).", e);
        }
    }
}

