/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.result;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.util.Try;

public final class ResultSetStream<T>
implements AutoCloseable {
    private final Class<T> objectClass;
    private final OrmConnectionImpl ormConnection;
    private final ResultSet resultSet;
    private final PreparedStatement stmt;

    public ResultSetStream(OrmConnectionImpl ormConnection, Class<T> objectClass, PreparedStatement stmt, ResultSet resultSet) {
        this.ormConnection = ormConnection;
        this.objectClass = objectClass;
        this.stmt = stmt;
        this.resultSet = resultSet;
    }

    private Iterator<T> iterator() {
        return new ResultSetIterator();
    }

    public Stream<T> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false).onClose(() -> this.close());
    }

    @Override
    public void close() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private class ResultSetIterator<S>
    implements Iterator<S> {
        private ResultSetIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                boolean hasNext = ResultSetStream.this.resultSet.next();
                if (!hasNext) {
                    ResultSetStream.this.close();
                }
                return hasNext;
            }
            catch (SQLException e) {
                ResultSetStream.this.close();
                throw Try.rethrow(e);
            }
        }

        @Override
        public S next() {
            try {
                return (S)ResultSetStream.this.ormConnection.mapRowToObject(ResultSetStream.this.objectClass, ResultSetStream.this.resultSet);
            }
            catch (SQLException e) {
                ResultSetStream.this.close();
                throw Try.rethrow(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

