/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.result;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.common.ColumnMetaData;
import org.nkjmlab.sorm4j.result.TableMetaData;

public final class TableMetaDataImpl
implements TableMetaData {
    private final String tableName;
    private final List<String> columns;
    private final List<String> primaryKeys;
    private final List<String> autoGeneratedColumns;
    private final boolean hasPrimaryKey;
    private final boolean hasAutoGeneratedColumns;
    private final List<String> notAutoGeneratedColumns;
    private final List<String> columnsForUpdate;
    private final String[] autoGeneratedColumnsArray;
    private final List<String> notPrimaryKeys;
    private final String columnsWithAliases;
    private final List<ColumnMetaData> columnsWithMetaData;

    public TableMetaDataImpl(String tableName, String columnAliasPrefix, List<ColumnMetaData> columnsWithMetaData, List<String> primaryKeys, List<String> autoGeneratedColumns) {
        this.tableName = tableName;
        this.columnsWithMetaData = List.copyOf(columnsWithMetaData);
        this.columns = Collections.unmodifiableList(columnsWithMetaData.stream().map(c -> c.getName()).collect(Collectors.toList()));
        this.primaryKeys = Collections.unmodifiableList(primaryKeys);
        this.autoGeneratedColumns = Collections.unmodifiableList(autoGeneratedColumns);
        this.notAutoGeneratedColumns = Collections.unmodifiableList(this.columns.stream().filter(col -> !autoGeneratedColumns.contains(col)).collect(Collectors.toList()));
        this.hasPrimaryKey = !primaryKeys.isEmpty();
        this.hasAutoGeneratedColumns = !autoGeneratedColumns.isEmpty();
        this.autoGeneratedColumnsArray = (String[])autoGeneratedColumns.toArray(String[]::new);
        this.notPrimaryKeys = Collections.unmodifiableList(this.columns.stream().filter(col -> !primaryKeys.contains(col)).collect(Collectors.toList()));
        this.columnsForUpdate = Collections.unmodifiableList(Stream.concat(this.notPrimaryKeys.stream(), primaryKeys.stream()).collect(Collectors.toList()));
        this.columnsWithAliases = String.join((CharSequence)", ", (CharSequence[])this.columns.stream().map(col -> tableName + "." + col + " as " + columnAliasPrefix + col).toArray(String[]::new));
    }

    @Override
    public List<String> getAutoGeneratedColumns() {
        return this.autoGeneratedColumns;
    }

    public String[] getAutoGeneratedColumnsArray() {
        return this.autoGeneratedColumnsArray;
    }

    @Override
    public String getColumnAliases() {
        return this.columnsWithAliases;
    }

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public List<String> getColumnsForUpdate() {
        return this.columnsForUpdate;
    }

    @Override
    public List<ColumnMetaData> getColumnsWithMetaData() {
        return this.columnsWithMetaData;
    }

    @Override
    public List<String> getNotAutoGeneratedColumns() {
        return this.notAutoGeneratedColumns;
    }

    @Override
    public List<String> getNotPrimaryKeys() {
        return this.notPrimaryKeys;
    }

    @Override
    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public boolean hasAutoGeneratedColumns() {
        return this.hasAutoGeneratedColumns;
    }

    @Override
    public boolean hasPrimaryKey() {
        return this.hasPrimaryKey;
    }

    public String toString() {
        return "TableMetaDataImpl [tableName=" + this.tableName + ", columns=" + this.columns + ", primaryKeys=" + this.primaryKeys + ", autoGeneratedColumns=" + this.autoGeneratedColumns + ", hasPrimaryKey=" + this.hasPrimaryKey + ", hasAutoGeneratedColumns=" + this.hasAutoGeneratedColumns + ", notAutoGeneratedColumns=" + this.notAutoGeneratedColumns + ", columnsForUpdate=" + this.columnsForUpdate + ", autoGeneratedColumnsArray=" + Arrays.toString(this.autoGeneratedColumnsArray) + ", notPrimaryKeys=" + this.notPrimaryKeys + ", columnsWithAliases=" + this.columnsWithAliases + ", columnsWithMetaData=" + this.columnsWithMetaData + "]";
    }
}

