/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.Arrays;
import java.util.function.Function;

public final class ParameterizedStringUtils {
    private ParameterizedStringUtils() {
    }

    public static String newString(String msg, Object ... params) {
        return ParameterizedStringUtils.newStringWithPlaceHolder(msg, "{}", params);
    }

    public static String newStringWithPlaceHolder(String msg, String placeholder, Object ... params) {
        if (params == null || params.length == 0) {
            return msg;
        }
        return ParameterizedStringUtils.newString(msg, placeholder, params.length, (Integer index) -> {
            Object o = params[index];
            if (o == null) {
                return "null";
            }
            if (o.getClass().isArray()) {
                String s = Arrays.deepToString(new Object[]{o});
                return s.substring(1, s.length());
            }
            return o.toString();
        });
    }

    public static String newString(String msg, String placeholder, int numOfParameter, Function<Integer, String> parameterReplacer) {
        int j;
        StringBuilder sbuf = new StringBuilder(msg.length() + 50);
        int i = 0;
        int placeholderStringLength = placeholder.length();
        for (int p = 0; p < numOfParameter && (j = msg.indexOf(placeholder, i)) != -1; ++p) {
            sbuf.append(msg, i, j);
            sbuf.append(parameterReplacer.apply(p));
            i = j + placeholderStringLength;
        }
        sbuf.append(msg, i, msg.length());
        return sbuf.toString();
    }
}

