/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.table;

import java.util.List;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.OrmStreamGenerator;
import org.nkjmlab.sorm4j.Sorm;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.common.ConsumerHandler;
import org.nkjmlab.sorm4j.common.FunctionHandler;
import org.nkjmlab.sorm4j.common.Tuple;
import org.nkjmlab.sorm4j.mapping.ResultSetTraverser;
import org.nkjmlab.sorm4j.mapping.RowMapper;
import org.nkjmlab.sorm4j.result.InsertResult;
import org.nkjmlab.sorm4j.result.TableMetaData;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;
import org.nkjmlab.sorm4j.util.sql.SelectSql;
import org.nkjmlab.sorm4j.util.sql.SqlKeyword;
import org.nkjmlab.sorm4j.util.table.BasicTable;
import org.nkjmlab.sorm4j.util.table.TableWithSchema;
import org.nkjmlab.sorm4j.util.table.TypedOrmStreamGenerator;

@Experimental
public interface Table<T> {
    public String getTableName();

    public Class<T> getValueType();

    public Sorm getSorm();

    @Experimental
    default public void acceptHandler(FunctionHandler<TypedOrmStreamGenerator<T>, Stream<T>> streamGenerator, ConsumerHandler<Stream<T>> streamHandler) {
        this.getSorm().acceptHandler((OrmStreamGenerator conn) -> (Stream)streamGenerator.apply(new TypedOrmStreamGenerator<T>(this.getValueType(), (OrmStreamGenerator)conn)), streamHandler);
    }

    @Experimental
    default public <R> R applyHandler(FunctionHandler<TypedOrmStreamGenerator<T>, Stream<T>> streamGenerator, FunctionHandler<Stream<T>, R> streamHandler) {
        return this.getSorm().applyHandler((OrmStreamGenerator conn) -> (Stream)streamGenerator.apply(new TypedOrmStreamGenerator<T>(this.getValueType(), (OrmStreamGenerator)conn)), streamHandler);
    }

    default public T readFirst(ParameterizedSql sql) {
        return this.getSorm().readFirst(this.getValueType(), sql);
    }

    default public T readFirst(String sql, Object ... parameters) {
        return this.getSorm().readFirst(this.getValueType(), sql, parameters);
    }

    default public List<T> readList(ParameterizedSql sql) {
        return this.getSorm().readList(this.getValueType(), sql);
    }

    default public List<T> readList(String sql, Object ... parameters) {
        return this.getSorm().readList(this.getValueType(), sql, parameters);
    }

    default public T readOne(ParameterizedSql sql) {
        return this.getSorm().readOne(this.getValueType(), sql);
    }

    default public T readOne(String sql, Object ... parameters) {
        return this.getSorm().readOne(this.getValueType(), sql, parameters);
    }

    default public RowMapper<T> getRowMapper() {
        return this.getSorm().getRowMapper(this.getValueType());
    }

    default public ResultSetTraverser<List<T>> getResultSetTraverser() {
        return this.getSorm().getResultSetTraverser(this.getValueType());
    }

    default public TableMetaData getTableMetaData() {
        return this.getSorm().getTableMetaData(this.getTableName());
    }

    default public boolean exists(T object) {
        return this.getSorm().exists(object);
    }

    default public int[] deleteIn(List<T> objects) {
        return this.getSorm().deleteIn(this.getTableName(), objects);
    }

    default public int deleteIn(T object) {
        return this.getSorm().deleteIn(this.getTableName(), object);
    }

    default public int[] deleteIn(T ... objects) {
        return this.getSorm().deleteIn(this.getTableName(), objects);
    }

    default public int deleteAllIn() {
        return this.getSorm().deleteAllIn(this.getTableName());
    }

    default public int[] insertIn(List<T> objects) {
        return this.getSorm().insertIn(this.getTableName(), objects);
    }

    default public int insertIn(T object) {
        return this.getSorm().insertIn(this.getTableName(), object);
    }

    default public int[] insertIn(T ... objects) {
        return this.getSorm().insertIn(this.getTableName(), objects);
    }

    default public InsertResult<T> insertAndGetIn(List<T> objects) {
        return this.getSorm().insertAndGetIn(this.getTableName(), objects);
    }

    default public InsertResult<T> insertAndGetIn(T object) {
        return this.getSorm().insertAndGetIn(this.getTableName(), object);
    }

    default public InsertResult<T> insertAndGetIn(T ... objects) {
        return this.getSorm().insertAndGetIn(this.getTableName(), objects);
    }

    default public int[] mergeIn(List<T> objects) {
        return this.getSorm().mergeIn(this.getTableName(), objects);
    }

    default public int mergeIn(T object) {
        return this.getSorm().mergeIn(this.getTableName(), object);
    }

    default public int[] mergeIn(T ... objects) {
        return this.getSorm().mergeIn(this.getTableName(), objects);
    }

    default public int[] updateIn(List<T> objects) {
        return this.getSorm().updateIn(this.getTableName(), objects);
    }

    default public int updateIn(T object) {
        return this.getSorm().updateIn(this.getTableName(), object);
    }

    default public int[] updateIn(T ... objects) {
        return this.getSorm().updateIn(this.getTableName(), objects);
    }

    default public <S> List<Tuple.Tuple2<T, S>> join(TableWithSchema<S> other, String onCondition) {
        return this.getSorm().join(this.getValueType(), other.getValueType(), onCondition);
    }

    default public <S> List<Tuple.Tuple2<T, S>> leftJoin(TableWithSchema<S> other, String onCondition) {
        return this.getSorm().leftJoin(this.getValueType(), other.getValueType(), onCondition);
    }

    default public List<T> selectAll() {
        return this.getSorm().selectAll(this.getValueType());
    }

    default public T selectByPrimaryKey(Object ... primaryKeyValues) {
        return this.getSorm().selectByPrimaryKey(this.getValueType(), primaryKeyValues);
    }

    default public List<T> selectListAllEqual(Tuple.Tuple2<?, ?> ... tupplesOfNameAndValue) {
        return this.getSorm().readList(this.getValueType(), this.getAllEqualSql(tupplesOfNameAndValue));
    }

    default public T selectFirstAllEqual(Tuple.Tuple2<?, ?> ... tupplesOfNameAndValue) {
        return this.getSorm().readFirst(this.getValueType(), this.getAllEqualSql(tupplesOfNameAndValue));
    }

    default public T selectOneAllEqual(Tuple.Tuple2<?, ?> ... tupplesOfNameAndValue) {
        return this.getSorm().readOne(this.getValueType(), this.getAllEqualSql(tupplesOfNameAndValue));
    }

    default public ParameterizedSql getAllEqualSql(Tuple.Tuple2<?, ?> ... tupplesOfNameAndValue) {
        int argLength = tupplesOfNameAndValue.length;
        if (argLength == 0) {
            return ParameterizedSql.of(SelectSql.selectStarFrom(this.getTableName()));
        }
        CharSequence[] conditions = new String[argLength];
        Object[] parameters = new Object[argLength];
        for (int i = 0; i < argLength; ++i) {
            Tuple.Tuple2<?, ?> tuple2 = tupplesOfNameAndValue[i];
            conditions[i] = tuple2.getT1() + "=?";
            parameters[i] = tuple2.getT2();
        }
        return ParameterizedSql.of(SelectSql.selectStarFrom(this.getTableName()) + SqlKeyword.WHERE + String.join((CharSequence)SqlKeyword.AND, conditions), parameters);
    }

    public static <T> Table<T> create(Sorm sorm, Class<T> objectClass) {
        return new BasicTable<T>(sorm, objectClass);
    }
}

