/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.Orm;
import org.nkjmlab.sorm4j.annotation.Experimental;

@Experimental
public final class TableSchema {
    private final String tableName;
    private final String tableSchema;
    private final List<String> columnNames;
    private final String createTableStatement;
    private final String dropTableStatement;
    private final List<String> createIndexStatements;

    public static Builder builder(String tableName) {
        return new Builder(tableName);
    }

    private TableSchema(String tableName, String tableSchema, List<String> columnNames, String createTableStatement, String dropTableStatement, List<String> createIndexStatements) {
        this.tableName = tableName;
        this.tableSchema = tableSchema;
        this.columnNames = columnNames;
        this.createTableStatement = createTableStatement;
        this.dropTableStatement = dropTableStatement;
        this.createIndexStatements = createIndexStatements;
    }

    public TableSchema createIndexesIfNotExists(Orm orm) {
        this.getCreateIndexIfNotExistsStatements().forEach(s -> orm.executeUpdate((String)s, new Object[0]));
        return this;
    }

    public TableSchema createTableIfNotExists(Orm orm) {
        orm.executeUpdate(this.getCreateTableIfNotExistsStatement(), new Object[0]);
        return this;
    }

    public TableSchema dropTableIfExists(Orm orm) {
        orm.executeUpdate(this.getDropTableIfExistsStatement(), new Object[0]);
        return this;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getCreateIndexIfNotExistsStatements() {
        return this.createIndexStatements;
    }

    public String getCreateTableIfNotExistsStatement() {
        return this.createTableStatement;
    }

    public String getDropTableIfExistsStatement() {
        return this.dropTableStatement;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public static class Builder {
        private String tableName;
        private final Map<String, String[]> columnDefinitions = new LinkedHashMap<String, String[]>();
        private String[] primaryKeys;
        private final List<String[]> uniqueColumnPairs = new ArrayList<String[]>();
        private final List<String[]> indexColumns = new ArrayList<String[]>();

        private static String createPrimaryKeyConstraint(String[] primaryKeys) {
            return primaryKeys == null || primaryKeys.length == 0 ? "" : ", primary key(" + String.join((CharSequence)", ", primaryKeys) + ")";
        }

        private static String createUniqueConstraint(List<String[]> uniqueColumnPairs) {
            return uniqueColumnPairs == null || uniqueColumnPairs.size() == 0 ? "" : ", " + String.join((CharSequence)", ", (CharSequence[])uniqueColumnPairs.stream().map(u -> "unique(" + String.join((CharSequence)", ", u) + ")").toArray(String[]::new));
        }

        private static List<String> getColumunNames(Map<String, String[]> columnDefinitions) {
            return columnDefinitions.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        }

        private static List<String> getColumuns(Map<String, String[]> columnDefinisions) {
            return columnDefinisions.keySet().stream().map(columnName -> columnName + " " + String.join((CharSequence)" ", Arrays.stream((String[])columnDefinisions.get(columnName)).map(s -> s.trim()).collect(Collectors.toList()))).collect(Collectors.toList());
        }

        private static String getCreateIndexOnStatement(String indexName, String tableName, String ... columns) {
            return "create index if not exists " + indexName + " on " + tableName + "(" + String.join((CharSequence)", ", columns) + ")";
        }

        private static String getTableSchema(String tableName, Map<String, String[]> columns, String[] primaryKeys, List<String[]> uniqueColumnPairs) {
            String schema = tableName + "(" + String.join((CharSequence)", ", Builder.getColumuns(columns)) + Builder.createPrimaryKeyConstraint(primaryKeys) + Builder.createUniqueConstraint(uniqueColumnPairs) + ")";
            return schema;
        }

        private static String[] toStringArray(Enum<?>[] enums) {
            return (String[])Arrays.stream(enums).map(e -> e.name()).toArray(String[]::new);
        }

        private Builder(String tableName) {
            this.tableName = tableName;
        }

        public Builder addColumnDefinition(Enum<?> columnName, String ... dataTypeAndOptions) {
            this.addColumnDefinition(columnName.name(), dataTypeAndOptions);
            return this;
        }

        public Builder addColumnDefinition(String columnName, String ... dataTypeAndOptions) {
            this.columnDefinitions.put(columnName, dataTypeAndOptions);
            return this;
        }

        public Builder addIndexDefinition(Enum<?> ... indexColumnPair) {
            this.addIndexDefinition(Builder.toStringArray(indexColumnPair));
            return this;
        }

        public Builder addIndexDefinition(String ... indexColumnPair) {
            this.indexColumns.add(indexColumnPair);
            return this;
        }

        public Builder addUniqueConstraint(Enum<?> ... uniqueColumnPair) {
            this.uniqueColumnPairs.add(Builder.toStringArray(uniqueColumnPair));
            return this;
        }

        public Builder addUniqueConstraint(String ... uniqueColumnPair) {
            this.uniqueColumnPairs.add(uniqueColumnPair);
            return this;
        }

        public TableSchema build() {
            if (this.columnDefinitions.isEmpty()) {
                return new TableSchema(this.tableName, "", Collections.emptyList(), "", "", Collections.emptyList());
            }
            String tableSchema = Builder.getTableSchema(this.tableName, this.columnDefinitions, this.primaryKeys, this.uniqueColumnPairs);
            String createTableStatement = "create table if not exists " + tableSchema;
            String dropTableStatement = "drop table if exists " + this.tableName;
            return new TableSchema(this.tableName, tableSchema, this.getColumunNames(), createTableStatement, dropTableStatement, this.getCreateIndexIfNotExistsStatements());
        }

        private List<String> getColumunNames() {
            return Builder.getColumunNames(this.columnDefinitions);
        }

        private List<String> getCreateIndexIfNotExistsStatements() {
            return this.indexColumns.stream().map(columns -> Builder.getCreateIndexOnStatement("index_in_" + this.tableName + "_on_" + String.join((CharSequence)"_", columns), this.tableName, columns)).collect(Collectors.toList());
        }

        public Builder setPrimaryKey(Enum<?> ... attributes) {
            this.setPrimaryKey(Builder.toStringArray(attributes));
            return this;
        }

        public Builder setPrimaryKey(String ... attributes) {
            this.primaryKeys = attributes;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }
    }
}

