/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.util.Try;

class ResultSetIterator<T>
implements Iterator<T> {
    private final OrmConnectionImpl ormConnection;
    private final Class<T> objectClass;
    private final ResultSet resultSet;

    public ResultSetIterator(OrmConnectionImpl connection, Class<T> objectClass, ResultSet resultSet) {
        this.ormConnection = connection;
        this.objectClass = objectClass;
        this.resultSet = resultSet;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public T next() {
        try {
            return this.ormConnection.mapRowToObject(this.objectClass, this.resultSet);
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

