/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.nkjmlab.sorm4j.internal.util.ConcurrentCache;

public final class StringCache {
    private static final Map<String, String> canonicalCaseCaches = new ConcurrentCache<String, String>(1024);
    private static final Map<String, String> upperCaseCaches = new ConcurrentCache<String, String>(256);
    private static final Map<String, String> lowerCaseCaches = new ConcurrentCache<String, String>(256);

    public static String toUpperCase(String str) {
        return upperCaseCaches.computeIfAbsent(str, key -> str.toUpperCase(Locale.ENGLISH));
    }

    public static String toLowerCase(String str) {
        return lowerCaseCaches.computeIfAbsent(str, key -> str.toLowerCase(Locale.ENGLISH));
    }

    public static String toCanonicalCase(String str) {
        return canonicalCaseCaches.computeIfAbsent(str, key -> str.replaceAll("_", "").replaceAll("\\s", "").toUpperCase(Locale.ENGLISH));
    }

    public static boolean containsAsCanonical(Collection<String> collection, String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (String e : collection) {
            if (!StringCache.toCanonicalCase(e).equals(StringCache.toCanonicalCase(str))) continue;
            return true;
        }
        return false;
    }

    private StringCache() {
    }
}

