/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql;

import java.util.Map;
import java.util.TreeMap;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.internal.sql.ParameterizedSqlImpl;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.sql.NamedParameterSql;
import org.nkjmlab.sorm4j.sql.OrderedParameterSql;

public interface ParameterizedSql {
    public String getSql();

    public Object[] getParameters();

    public String getBindedSql();

    public static ParameterizedSql of(String sql) {
        return ParameterizedSqlImpl.of(sql, new Object[0]);
    }

    public static ParameterizedSql of(String sql, Object ... parameters) {
        return ParameterizedSqlImpl.of(sql, parameters);
    }

    public static ParameterizedSql parse(String sql, Object ... parameters) {
        return OrderedParameterSql.parse(sql, parameters);
    }

    public static ParameterizedSql parse(String sql, Map<String, Object> parameters) {
        return NamedParameterSql.parse(sql, parameters);
    }

    @Experimental
    public static String embedParameter(String sql, Object ... parameters) {
        String ret = ParameterizedStringUtils.newString(sql, "{?}", parameters.length, index -> parameters[index] == null ? null : parameters[index].toString());
        if (ret.contains("{?}")) {
            throw new SormException(ParameterizedStringUtils.newString("Could not embed all parameters. sql={},parameters={}", sql, parameters));
        }
        return ret;
    }

    @Experimental
    public static String embedParameter(String sql, Map<String, Object> parameters) {
        TreeMap orderdParams = new TreeMap();
        parameters.keySet().stream().forEach(key -> {
            int pos = sql.indexOf("{:" + key + "}");
            if (pos == -1) {
                return;
            }
            orderdParams.put(pos, parameters.get(key));
        });
        String _sql = sql.replaceAll("\\{:.*?\\}", "{?}");
        Object[] _parameters = orderdParams.values().toArray();
        return ParameterizedSql.embedParameter(_sql, _parameters);
    }
}

