/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.context;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.nkjmlab.sorm4j.context.ColumnValueToMapValueConverter;

public final class DefaultColumnValueToMapValueConverter
implements ColumnValueToMapValueConverter {
    private final Map<Integer, ColumnValueToMapValueConverter> converters;

    public DefaultColumnValueToMapValueConverter() {
        this(Collections.emptyMap());
    }

    public DefaultColumnValueToMapValueConverter(Map<Integer, ColumnValueToMapValueConverter> converters) {
        this.converters = Map.copyOf(converters);
    }

    @Override
    public Object convertToValue(ResultSet resultSet, int column, int sqlType) throws SQLException {
        ColumnValueToMapValueConverter converter = this.converters.get(sqlType);
        if (converter != null) {
            return converter.convertToValue(resultSet, column, sqlType);
        }
        switch (sqlType) {
            case 2003: {
                return resultSet.getArray(column);
            }
            case -5: {
                long ret = resultSet.getLong(column);
                return ret == 0L && resultSet.wasNull() ? null : Long.valueOf(ret);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return resultSet.getBytes(column);
            }
            case -7: 
            case 16: {
                boolean ret = resultSet.getBoolean(column);
                return !ret && resultSet.wasNull() ? null : Boolean.valueOf(ret);
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return resultSet.getString(column);
            }
            case 70: {
                return resultSet.getURL(column);
            }
            case 91: {
                return resultSet.getDate(column);
            }
            case 2: 
            case 3: {
                return resultSet.getBigDecimal(column);
            }
            case 7: 
            case 8: {
                double ret = resultSet.getDouble(column);
                return ret == 0.0 && resultSet.wasNull() ? null : Double.valueOf(ret);
            }
            case 6: {
                float ret = resultSet.getFloat(column);
                return ret == 0.0f && resultSet.wasNull() ? null : Float.valueOf(ret);
            }
            case 4: {
                int ret = resultSet.getInt(column);
                return ret == 0 && resultSet.wasNull() ? null : Integer.valueOf(ret);
            }
            case 0: {
                return null;
            }
            case 2006: {
                return resultSet.getRef(column);
            }
            case -8: {
                return resultSet.getRowId(column);
            }
            case 5: {
                short ret = (short)resultSet.getInt(column);
                return ret == 0 && resultSet.wasNull() ? null : Short.valueOf(ret);
            }
            case 92: {
                return resultSet.getTime(column);
            }
            case 93: {
                return resultSet.getTimestamp(column);
            }
            case 2014: {
                return resultSet.getObject(column);
            }
            case -6: {
                byte ret = resultSet.getByte(column);
                return ret == 0 && resultSet.wasNull() ? null : Byte.valueOf(ret);
            }
            case 1111: 
            case 2000: {
                return resultSet.getObject(column);
            }
        }
        return resultSet.getObject(column);
    }
}

