/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.context;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.context.SqlParameterSetter;
import org.nkjmlab.sorm4j.context.SqlParametersSetter;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;

public final class DefaultSqlParametersSetter
implements SqlParametersSetter {
    private final Map<Class<?>, SqlParameterSetter> setters;

    public DefaultSqlParametersSetter() {
        this.setters = Collections.emptyMap();
    }

    public DefaultSqlParametersSetter(Map<Class<?>, SqlParameterSetter> setters) {
        this.setters = Map.copyOf(setters);
    }

    @Override
    public void setParameters(PreparedStatement stmt, Object ... parameters) throws SQLException {
        if (parameters == null) {
            return;
        }
        for (int i = 1; i <= parameters.length; ++i) {
            this.setParameter(stmt, i, parameters[i - 1]);
        }
    }

    private void setParameter(PreparedStatement stmt, int parameterIndex, Object parameter) throws SQLException {
        if (parameter == null) {
            stmt.setNull(parameterIndex, 0);
            return;
        }
        Class<?> type = parameter.getClass();
        SqlParameterSetter setter = this.setters.get(type);
        if (setter != null) {
            setter.setParameter(stmt, parameterIndex, parameter);
            return;
        }
        switch (type.getName()) {
            case "java.lang.Boolean": 
            case "boolean": {
                stmt.setBoolean(parameterIndex, (Boolean)parameter);
                return;
            }
            case "java.lang.Byte": 
            case "byte": {
                stmt.setByte(parameterIndex, (Byte)parameter);
                return;
            }
            case "java.lang.Short": 
            case "short": {
                stmt.setShort(parameterIndex, (Short)parameter);
                return;
            }
            case "java.lang.Integer": 
            case "int": {
                stmt.setInt(parameterIndex, (Integer)parameter);
                return;
            }
            case "java.lang.Long": 
            case "long": {
                stmt.setLong(parameterIndex, (Long)parameter);
                return;
            }
            case "java.lang.Float": 
            case "float": {
                stmt.setFloat(parameterIndex, ((Float)parameter).floatValue());
                return;
            }
            case "java.lang.Double": 
            case "double": {
                stmt.setDouble(parameterIndex, (Double)parameter);
                return;
            }
            case "java.lang.Character": 
            case "char": {
                stmt.setString(parameterIndex, parameter == null ? null : "" + (Character)parameter);
                return;
            }
            case "java.lang.String": {
                stmt.setString(parameterIndex, (String)parameter);
                return;
            }
            case "java.math.BigDecimal": {
                stmt.setBigDecimal(parameterIndex, (BigDecimal)parameter);
                return;
            }
            case "java.sql.Date": {
                stmt.setDate(parameterIndex, (Date)parameter);
                return;
            }
            case "java.sql.Time": {
                stmt.setTime(parameterIndex, (Time)parameter);
                return;
            }
            case "java.sql.Timestamp": {
                stmt.setTimestamp(parameterIndex, (Timestamp)parameter);
                return;
            }
            case "java.util.Date": 
            case "java.time.LocalTime": 
            case "java.time.LocalDate": 
            case "java.time.LocalDateTime": 
            case "java.time.OffsetTime": 
            case "java.time.OffsetDateTime": 
            case "java.time.Instant": 
            case "java.util.UUID": {
                stmt.setObject(parameterIndex, parameter);
                return;
            }
        }
        if (type.isArray()) {
            Class<?> compType = type.getComponentType();
            this.procArray(compType, stmt, parameterIndex, parameter);
        } else if (parameter instanceof List) {
            List list = (List)parameter;
            if (list.isEmpty()) {
                throw new SormException("Size of parameter which type is List should be at least one. ");
            }
            this.procArray(list.get(0).getClass(), stmt, parameterIndex, list.toArray());
        } else if (type.isEnum()) {
            stmt.setString(parameterIndex, parameter.toString());
        } else if (parameter instanceof Blob) {
            stmt.setBlob(parameterIndex, (Blob)parameter);
        } else if (parameter instanceof Clob) {
            stmt.setClob(parameterIndex, (Clob)parameter);
        } else if (parameter instanceof InputStream) {
            stmt.setBinaryStream(parameterIndex, (InputStream)parameter);
        } else if (parameter instanceof Reader) {
            stmt.setCharacterStream(parameterIndex, (Reader)parameter);
        } else {
            stmt.setObject(parameterIndex, parameter);
        }
    }

    private void procArray(Class<?> compType, PreparedStatement stmt, int parameterIndex, Object parameter) throws SQLException {
        String typeName = compType.getName();
        if (typeName.equals("byte")) {
            stmt.setBytes(parameterIndex, (byte[])parameter);
        } else {
            stmt.setArray(parameterIndex, DefaultSqlParametersSetter.toSqlArray(typeName, stmt.getConnection(), parameter));
        }
    }

    static Array toSqlArray(String typeName, Connection conn, Object parameter) throws SQLException {
        switch (typeName) {
            case "boolean": {
                return conn.createArrayOf("boolean", ArrayUtils.toObjectArray((boolean[])parameter));
            }
            case "byte": {
                return conn.createArrayOf("tinyint", ArrayUtils.toObjectArray((byte[])parameter));
            }
            case "short": {
                return conn.createArrayOf("smallint", ArrayUtils.toObjectArray((short[])parameter));
            }
            case "int": {
                return conn.createArrayOf("integer", ArrayUtils.toObjectArray((int[])parameter));
            }
            case "long": {
                return conn.createArrayOf("bigint", ArrayUtils.toObjectArray((long[])parameter));
            }
            case "float": {
                return conn.createArrayOf("real", ArrayUtils.toObjectArray((float[])parameter));
            }
            case "double": {
                return conn.createArrayOf("double", ArrayUtils.toObjectArray((double[])parameter));
            }
            case "char": {
                return conn.createArrayOf("character", ArrayUtils.toObjectArray((char[])parameter));
            }
        }
        return conn.createArrayOf("java_object", (Object[])parameter);
    }
}

