/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.common.FunctionHandler;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.common.TableMetaData;
import org.nkjmlab.sorm4j.common.Tuple;
import org.nkjmlab.sorm4j.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.context.ColumnValueToMapValueConverter;
import org.nkjmlab.sorm4j.context.PreparedStatementSupplier;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.context.SqlParametersSetter;
import org.nkjmlab.sorm4j.context.TableSql;
import org.nkjmlab.sorm4j.internal.SormContextImpl;
import org.nkjmlab.sorm4j.internal.TableMappedOrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.mapping.SqlParametersToTableMapping;
import org.nkjmlab.sorm4j.internal.mapping.SqlResultToColumnsMapping;
import org.nkjmlab.sorm4j.internal.result.ResultSetStreamOrmConnection;
import org.nkjmlab.sorm4j.internal.result.RowMapImpl;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.mapping.ResultSetTraverser;
import org.nkjmlab.sorm4j.mapping.RowMapper;
import org.nkjmlab.sorm4j.result.InsertResult;
import org.nkjmlab.sorm4j.result.JdbcDatabaseMetaData;
import org.nkjmlab.sorm4j.result.ResultSetStream;
import org.nkjmlab.sorm4j.result.RowMap;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;
import org.nkjmlab.sorm4j.table.TableMappedOrmConnection;
import org.nkjmlab.sorm4j.util.logger.LogPoint;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;
import org.nkjmlab.sorm4j.util.sql.SelectSql;
import org.nkjmlab.sorm4j.util.sql.SqlKeyword;

public class OrmConnectionImpl
implements OrmConnection {
    private static final Supplier<int[]> EMPTY_INT_SUPPLIER = () -> new int[0];
    private final SormContextImpl sormContext;
    private final Connection connection;

    public OrmConnectionImpl(Connection connection, SormContextImpl sormContext) {
        this.connection = connection;
        this.sormContext = sormContext;
    }

    @Override
    public void close() {
        try {
            this.getJdbcConnection().close();
        }
        catch (SQLException e) {
            this.sormContext.getLoggerContext().getLogger(OrmConnectionImpl.class).warn("jdbc connection close error", new Object[0]);
        }
    }

    @Override
    public void commit() {
        Try.runOrElseThrow(() -> this.getJdbcConnection().commit(), Try::rethrow);
    }

    @Override
    public <T> int[] delete(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.delete((T)array));
    }

    @Override
    public <T> int delete(T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        return this.executeUpdate(mapping.getSql().getDeleteSql(), mapping.getDeleteParameters(object));
    }

    @Override
    public <T> int[] delete(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.batch(this.connection, mapping.getSql().getDeleteSql(), obj -> mapping.getDeleteParameters(obj), objects), EMPTY_INT_SUPPLIER);
    }

    @Override
    public <T> int deleteAll(Class<T> objectClass) {
        return this.deleteAllIn(this.getTableName(objectClass));
    }

    @Override
    public int deleteAllIn(String tableName) {
        return this.executeUpdate("DELETE FROM " + tableName, new Object[0]);
    }

    @Override
    public <T> int[] deleteIn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.deleteIn(tableName, (T)array));
    }

    @Override
    public <T> int deleteIn(String tableName, T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(tableName, object.getClass());
        return this.executeUpdate(mapping.getSql().getDeleteSql(), mapping.getDeleteParameters(object));
    }

    @Override
    public <T> int[] deleteIn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.batch(this.connection, mapping.getSql().getDeleteSql(), obj -> mapping.getDeleteParameters(obj), objects), EMPTY_INT_SUPPLIER);
    }

    private final <T, R> R execSqlIfParameterExists(String tableName, T[] objects, Function<SqlParametersToTableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(tableName, objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    private final <T, R> R execSqlIfParameterExists(T[] objects, Function<SqlParametersToTableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    @Override
    public <T> T executeQuery(FunctionHandler<Connection, PreparedStatement> statementSupplier, ResultSetTraverser<T> traverser) {
        return OrmConnectionImpl.executeQueryAndClose(this.connection, traverser, statementSupplier);
    }

    @Override
    public <T> List<T> executeQuery(FunctionHandler<Connection, PreparedStatement> statementSupplier, RowMapper<T> rowMapper) {
        return OrmConnectionImpl.executeQueryAndClose(this.connection, ResultSetTraverser.of(rowMapper), statementSupplier);
    }

    @Override
    public <T> T executeQuery(ParameterizedSql sql, ResultSetTraverser<T> resultSetTraverser) {
        return OrmConnectionImpl.executeQueryAndClose(this.getLoggerContext(), this.getJdbcConnection(), this.getPreparedStatementSupplier(), this.getSqlParametersSetter(), sql.getSql(), sql.getParameters(), resultSetTraverser);
    }

    @Override
    public <T> List<T> executeQuery(ParameterizedSql sql, RowMapper<T> rowMapper) {
        return this.executeQuery(sql, ResultSetTraverser.of(rowMapper));
    }

    @Override
    public int executeUpdate(ParameterizedSql sql) {
        return this.executeUpdate(sql.getSql(), sql.getParameters());
    }

    @Override
    public int executeUpdate(String sql, Object ... parameters) {
        int ret = OrmConnectionImpl.executeUpdateAndClose(this.getLoggerContext(), this.connection, this.getSqlParametersSetter(), this.getPreparedStatementSupplier(), sql, parameters);
        return ret;
    }

    @Override
    public <T> boolean exists(String tableName, T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(tableName, object.getClass());
        return this.existsHelper(mapping.getSql(), mapping.getPrimaryKeyParameters(object));
    }

    @Override
    public <T> boolean exists(T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        return this.existsHelper(mapping.getSql(), mapping.getPrimaryKeyParameters(object));
    }

    @Override
    public <T> boolean exists(String tableName, Object ... primaryKeyValues) {
        return this.existsHelper(this.getTableSql(tableName), primaryKeyValues);
    }

    @Override
    public <T> boolean exists(Class<T> type, Object ... primaryKeyValues) {
        return this.existsHelper(this.getTableSql(type), primaryKeyValues);
    }

    private <T> boolean existsHelper(TableSql tableSql, Object ... primaryKeyValues) {
        String sql = tableSql.getExistsSql();
        return this.readFirst(Integer.class, sql, primaryKeyValues) != null;
    }

    private <T> SqlParametersToTableMapping<T> getCastedTableMapping(String tableName, Class<?> objectClass) {
        return this.sormContext.getCastedTableMapping(this.connection, tableName, objectClass);
    }

    private <T> SqlParametersToTableMapping<T> getCastedTableMapping(Class<?> objectClass) {
        return this.sormContext.getCastedTableMapping(this.connection, objectClass);
    }

    <T> SqlResultToColumnsMapping<T> getColumnsMapping(Class<T> objectClass) {
        return this.sormContext.getColumnsMapping(objectClass);
    }

    private ColumnValueToJavaObjectConverters getColumnValueToJavaObjectConverter() {
        return this.sormContext.getColumnValueToJavaObjectConverter();
    }

    private ColumnValueToMapValueConverter getColumnValueToMapValueConverter() {
        return this.sormContext.getColumnValueToMapValueConverter();
    }

    @Override
    public SormContext getContext() {
        return this.sormContext;
    }

    @Override
    public Connection getJdbcConnection() {
        return this.connection;
    }

    @Override
    public JdbcDatabaseMetaData getJdbcDatabaseMetaData() {
        try {
            DatabaseMetaData metaData = this.connection.getMetaData();
            return JdbcDatabaseMetaData.of(metaData);
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    private LoggerContext getLoggerContext() {
        return this.sormContext.getLoggerContext();
    }

    private PreparedStatementSupplier getPreparedStatementSupplier() {
        return this.sormContext.getPreparedStatementSupplier();
    }

    @Override
    public <T> ResultSetTraverser<List<T>> getResultSetTraverser(Class<T> objectClass) {
        return resultSet -> this.traverseAndMapToList(objectClass, resultSet);
    }

    @Override
    public <T> RowMapper<T> getRowMapper(Class<T> objectClass) {
        return (resultSet, rowNum) -> this.mapRowToObject(objectClass, resultSet);
    }

    private SqlParametersSetter getSqlParametersSetter() {
        return this.sormContext.getSqlParametersSetter();
    }

    public <T> SqlParametersToTableMapping<T> getTableMapping(Class<T> objectClass) {
        return this.sormContext.getTableMapping(this.connection, objectClass);
    }

    @Override
    public TableSql getTableSql(Class<?> objectClass) {
        return this.getTableMapping(objectClass).getSql();
    }

    @Override
    public TableSql getTableSql(String tableName) {
        return this.sormContext.getTableSql(this.getTableMetaData(tableName));
    }

    @Override
    public TableMetaData getTableMetaData(Class<?> objectClass) {
        return this.getTableMapping(objectClass).getTableMetaData();
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        return this.sormContext.getTableMetaData(this.connection, tableName);
    }

    @Override
    public String getTableName(Class<?> objectClass) {
        return this.sormContext.getTableName(this.connection, objectClass);
    }

    @Override
    public <T> int[] insert(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insert((T)array));
    }

    @Override
    public <T> int insert(T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        return this.executeUpdate(mapping.getSql().getInsertSql(), mapping.getInsertParameters(object));
    }

    @Override
    public <T> int[] insert(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.insert(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    @Override
    public <T> InsertResult<T> insertAndGet(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insertAndGet((T)array));
    }

    @Override
    public <T> InsertResult<T> insertAndGet(T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        return mapping.insertAndGet(this.getJdbcConnection(), object);
    }

    @Override
    public <T> InsertResult<T> insertAndGet(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.insertAndGet(this.getJdbcConnection(), objects), () -> null);
    }

    @Override
    public <T> InsertResult<T> insertAndGetIn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insertAndGetIn(tableName, (T)array));
    }

    @Override
    public <T> InsertResult<T> insertAndGetIn(String tableName, T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(tableName, object.getClass());
        return mapping.insertAndGet(this.getJdbcConnection(), object);
    }

    @Override
    public <T> InsertResult<T> insertAndGetIn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.insertAndGet(this.getJdbcConnection(), objects), () -> null);
    }

    @Override
    public <T> int[] insertIn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insertIn(tableName, (T)array));
    }

    @Override
    public <T> int insertIn(String tableName, T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(tableName, object.getClass());
        return this.executeUpdate(mapping.getSql().getInsertSql(), mapping.getInsertParameters(object));
    }

    @Override
    public <T> int[] insertIn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.insert(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] insertMapIn(String tableName, List<RowMap> objects) {
        boolean origAutoCommit = OrmConnectionImpl.getAutoCommit(this.connection);
        try {
            OrmConnectionImpl.setAutoCommit(this.connection, false);
            int[] ret = objects.stream().mapToInt(o -> this.insertMapIn(tableName, (RowMap)o)).toArray();
            OrmConnectionImpl.setAutoCommit(this.connection, true);
            this.commit();
            int[] nArray = ret;
            return nArray;
        }
        finally {
            OrmConnectionImpl.commitOrRollback(this.connection, origAutoCommit);
            this.setAutoCommit(origAutoCommit);
        }
    }

    @Override
    public int insertMapIn(String tableName, RowMap object) {
        String sql = this.getTableSql(tableName).getInsertSql();
        return this.executeUpdate(sql, this.toInsertParameters(tableName, object));
    }

    private Object[] toInsertParameters(String tableName, RowMap object) {
        List<String> cols = this.getTableMetaData(tableName).getNotAutoGeneratedColumns();
        return cols.stream().map(col -> object.get(col)).toArray();
    }

    @Override
    public int[] insertMapIn(String tableName, RowMap ... objects) {
        return this.insertMapIn(tableName, Arrays.asList(objects));
    }

    @Override
    public <T1, T2, T3> List<Tuple.Tuple3<T1, T2, T3>> joinOn(Class<T1> t1, Class<T2> t2, Class<T3> t3, String t1T2OnCondition, String t2T3OnCondition) {
        return this.readTupleList(t1, t2, t3, this.joinHelper(SqlKeyword.JOIN, t1, t2, t1T2OnCondition, t3, t2T3OnCondition), new Object[0]);
    }

    @Override
    public <T1, T2> List<Tuple.Tuple2<T1, T2>> joinOn(Class<T1> t1, Class<T2> t2, String onCondition) {
        return this.readTupleList(t1, t2, this.joinHelper(SqlKeyword.JOIN, t1, t2, SqlKeyword.ON + onCondition), new Object[0]);
    }

    @Override
    public <T1, T2> List<Tuple.Tuple2<T1, T2>> joinUsing(Class<T1> t1, Class<T2> t2, String ... columns) {
        return this.readTupleList(t1, t2, this.joinHelper(SqlKeyword.JOIN, t1, t2, " using (" + SelectSql.joinCommaAndSpace(columns) + ")"), new Object[0]);
    }

    private <T1, T2, T3> String joinHelper(String joinType, Class<T1> t1, Class<T2> t2, String joinCondition) {
        TableMetaData t1m = this.getTableMapping(t1).getTableMetaData();
        TableMetaData t2m = this.getTableMapping(t2).getTableMetaData();
        String sql = SqlKeyword.SELECT + t1m.getColumnAliases() + ", " + t2m.getColumnAliases() + ", " + SqlKeyword.FROM + t1m.getTableName() + joinType + t2m.getTableName() + joinCondition;
        return sql;
    }

    private <T1, T2, T3> String joinHelper(String joinType, Class<T1> t1, Class<T2> t2, String t1T2OnCondition, Class<T3> t3, String t2T3OnCondition) {
        TableMetaData t1m = this.getTableMapping(t1).getTableMetaData();
        TableMetaData t2m = this.getTableMapping(t2).getTableMetaData();
        TableMetaData t3m = this.getTableMapping(t3).getTableMetaData();
        String sql = SqlKeyword.SELECT + t1m.getColumnAliases() + ", " + t2m.getColumnAliases() + ", " + t3m.getColumnAliases() + SqlKeyword.FROM + t1m.getTableName() + joinType + t2m.getTableName() + SqlKeyword.ON + t1T2OnCondition + joinType + t3m.getTableName() + SqlKeyword.ON + t2T3OnCondition;
        return sql;
    }

    @Override
    public <T1, T2> List<Tuple.Tuple2<T1, T2>> leftJoinOn(Class<T1> t1, Class<T2> t2, String onCondition) {
        return this.readTupleList(t1, t2, this.joinHelper(SqlKeyword.LEFT + SqlKeyword.JOIN, t1, t2, SqlKeyword.ON + onCondition), new Object[0]);
    }

    @Override
    public <T1, T2, T3> List<Tuple.Tuple3<T1, T2, T3>> leftJoinOn(Class<T1> t1, Class<T2> t2, Class<T3> t3, String t1T2OnCondition, String t2T3OnCondition) {
        return this.readTupleList(t1, t2, t3, this.joinHelper(SqlKeyword.LEFT + SqlKeyword.JOIN, t1, t2, t1T2OnCondition, t3, t2T3OnCondition), new Object[0]);
    }

    public <T> T loadFirst(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return resultSet.next() ? (T)this.mapRowToObject(objectClass, resultSet) : null;
    }

    private final <T> T loadResultContainerObject(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return this.getColumnsMapping(objectClass).loadResultContainerObject(resultSet);
    }

    public final <T> List<T> loadResultContainerObjectList(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return this.getColumnsMapping(objectClass).traverseAndMap(resultSet);
    }

    private final <T> List<T> loadSupportedReturnedTypeList(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        ArrayList<T> ret = new ArrayList<T>();
        int sqlType = OrmConnectionImpl.getOneSqlType(objectClass, resultSet);
        while (resultSet.next()) {
            ret.add(this.toSupportedReturnedTypeObject(resultSet, sqlType, objectClass));
        }
        return ret;
    }

    private RowMap mapRowToMap(ResultSet resultSet) throws SQLException {
        ColumnsAndTypes ct = ColumnsAndTypes.createColumnsAndTypes(resultSet);
        return this.toSingleRowMap(resultSet, ct.getColumns(), ct.getColumnTypes());
    }

    public <T> T mapRowToObject(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return (T)(this.getColumnValueToJavaObjectConverter().isSupportedReturnedType(objectClass) ? this.toSupportedReturnedTypeObject(resultSet, OrmConnectionImpl.getOneSqlType(objectClass, resultSet), objectClass) : (objectClass.equals(RowMap.class) ? this.mapRowToMap(resultSet) : this.loadResultContainerObject(objectClass, resultSet)));
    }

    @Override
    public <T> int[] merge(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.merge((T)array));
    }

    @Override
    public <T> int merge(T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        return this.executeUpdate(mapping.getSql().getMergeSql(), mapping.getMergeParameters(object));
    }

    @Override
    public <T> int[] merge(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.merge(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    @Override
    public <T> int[] mergeIn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.mergeIn(tableName, (T)array));
    }

    @Override
    public <T> int mergeIn(String tableName, T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(tableName, object.getClass());
        return this.executeUpdate(mapping.getSql().getMergeSql(), mapping.getMergeParameters(object));
    }

    @Override
    public <T> int[] mergeIn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.merge(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    @Override
    public <T> ResultSetStream<T> stream(Class<T> objectClass, ParameterizedSql sql) {
        return this.stream(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> ResultSetStream<T> stream(Class<T> objectClass, String sql, Object ... parameters) {
        return new ResultSetStreamOrmConnection<T>(this, objectClass, sql, parameters);
    }

    @Override
    public <T> ResultSetStream<T> streamAll(Class<T> type) {
        return this.stream(type, this.getTableMapping(type).getSql().getSelectAllSql(), new Object[0]);
    }

    @Override
    public <T> T readFirst(Class<T> objectClass, ParameterizedSql sql) {
        return this.readFirst(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> T readFirst(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)OrmConnectionImpl.executeQueryAndClose(this.getLoggerContext(), this.getJdbcConnection(), this.getPreparedStatementSupplier(), this.getSqlParametersSetter(), sql, parameters, resultSet -> this.loadFirst(objectClass, resultSet));
    }

    @Override
    public <T> List<T> readList(Class<T> objectClass, ParameterizedSql sql) {
        return this.readList(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> List<T> readList(Class<T> objectClass, String sql, Object ... parameters) {
        return OrmConnectionImpl.executeQueryAndClose(this.getLoggerContext(), this.getJdbcConnection(), this.getPreparedStatementSupplier(), this.getSqlParametersSetter(), sql, parameters, resultSet -> this.traverseAndMapToList(objectClass, resultSet));
    }

    @Override
    public <T> T readOne(Class<T> objectClass, ParameterizedSql sql) {
        return this.readOne(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> T readOne(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)OrmConnectionImpl.executeQueryAndClose(this.getLoggerContext(), this.getJdbcConnection(), this.getPreparedStatementSupplier(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            Object ret = null;
            if (!resultSet.next()) {
                throw new SormException("No result returned");
            }
            ret = this.mapRowToObject(objectClass, resultSet);
            if (resultSet.next()) {
                throw new SormException("Non-unique result returned");
            }
            return ret;
        });
    }

    @Override
    public <T1, T2, T3> List<Tuple.Tuple3<T1, T2, T3>> readTupleList(Class<T1> t1, Class<T2> t2, Class<T3> t3, ParameterizedSql sql) {
        return this.readTupleList(t1, t2, t3, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T1, T2, T3> List<Tuple.Tuple3<T1, T2, T3>> readTupleList(Class<T1> t1, Class<T2> t2, Class<T3> t3, String sql, Object ... parameters) {
        List ret = OrmConnectionImpl.executeQueryAndClose(this.getLoggerContext(), this.getJdbcConnection(), this.getPreparedStatementSupplier(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            ArrayList ret1 = new ArrayList();
            while (resultSet.next()) {
                ret1.add(Tuple.of(this.loadResultContainerObject(t1, resultSet), this.loadResultContainerObject(t2, resultSet), this.loadResultContainerObject(t3, resultSet)));
            }
            return ret1;
        });
        return ret;
    }

    @Override
    public <T1, T2> List<Tuple.Tuple2<T1, T2>> readTupleList(Class<T1> t1, Class<T2> t2, ParameterizedSql sql) {
        return this.readTupleList(t1, t2, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T1, T2> List<Tuple.Tuple2<T1, T2>> readTupleList(Class<T1> t1, Class<T2> t2, String sql, Object ... parameters) {
        List ret = OrmConnectionImpl.executeQueryAndClose(this.getLoggerContext(), this.getJdbcConnection(), this.getPreparedStatementSupplier(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            ArrayList ret1 = new ArrayList();
            while (resultSet.next()) {
                ret1.add(Tuple.of(this.loadResultContainerObject(t1, resultSet), this.loadResultContainerObject(t2, resultSet)));
            }
            return ret1;
        });
        return ret;
    }

    @Override
    public void rollback() {
        try {
            this.getJdbcConnection().rollback();
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public final <T> List<T> selectAll(Class<T> objectClass) {
        return this.readList(objectClass, this.getCastedTableMapping(objectClass).getSql().getSelectAllSql(), new Object[0]);
    }

    @Override
    public <T> T selectByPrimaryKey(Class<T> objectClass, Object ... primaryKeyValues) {
        String sql = this.getTableMapping(objectClass).getSql().getSelectByPrimaryKeySql();
        return (T)OrmConnectionImpl.executeQueryAndClose(this.getLoggerContext(), this.getJdbcConnection(), this.getPreparedStatementSupplier(), this.getSqlParametersSetter(), sql, primaryKeyValues, resultSet -> resultSet.next() ? this.getColumnsMapping(objectClass).loadResultContainerObjectByPrimaryKey(objectClass, resultSet) : null);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        try {
            this.getJdbcConnection().setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    private RowMap toSingleRowMap(ResultSet resultSet, List<String> columns, List<Integer> columnTypes) throws SQLException {
        int colsNum = columns.size();
        RowMapImpl ret = new RowMapImpl(colsNum + 1, 1.0f);
        for (int i = 1; i <= colsNum; ++i) {
            ret.put(columns.get(i - 1), this.getColumnValueToMapValueConverter().convertToValue(resultSet, i, columnTypes.get(i - 1)));
        }
        return ret;
    }

    private <T> T toSupportedReturnedTypeObject(ResultSet resultSet, int sqlType, Class<T> objectClass) throws SQLException {
        return this.getColumnValueToJavaObjectConverter().convertTo(resultSet, 1, sqlType, objectClass);
    }

    private <T> List<T> traverseAndMapToList(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return this.getColumnValueToJavaObjectConverter().isSupportedReturnedType(objectClass) ? this.loadSupportedReturnedTypeList(objectClass, resultSet) : (objectClass.equals(RowMap.class) ? this.traverseAndMapToRowMapList(resultSet) : this.loadResultContainerObjectList(objectClass, resultSet));
    }

    private List<RowMap> traverseAndMapToRowMapList(ResultSet resultSet) throws SQLException {
        ArrayList<RowMap> ret = new ArrayList<RowMap>();
        ColumnsAndTypes ct = ColumnsAndTypes.createColumnsAndTypes(resultSet);
        while (resultSet.next()) {
            ret.add(this.toSingleRowMap(resultSet, ct.getColumns(), ct.getColumnTypes()));
        }
        return ret;
    }

    @Override
    public <T> int[] update(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.update((T)array));
    }

    @Override
    public <T> int update(T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        return this.executeUpdate(mapping.getSql().getUpdateSql(), mapping.getUpdateParameters(object));
    }

    @Override
    public <T> int[] update(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.batch(this.connection, mapping.getSql().getUpdateSql(), obj -> mapping.getUpdateParameters(obj), objects), EMPTY_INT_SUPPLIER);
    }

    @Override
    public <T> int[] updateIn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.updateIn(tableName, (T)array));
    }

    @Override
    public <T> int updateIn(String tableName, T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(tableName, object.getClass());
        return this.executeUpdate(mapping.getSql().getUpdateSql(), mapping.getUpdateParameters(object));
    }

    @Override
    public <T> int[] updateIn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.batch(this.connection, mapping.getSql().getUpdateSql(), obj -> mapping.getUpdateParameters(obj), objects), EMPTY_INT_SUPPLIER);
    }

    private static <T, R> R applytoArray(List<T> objects, Function<T[], R> sqlFunc) {
        return sqlFunc.apply((T[][])objects.toArray(Object[]::new));
    }

    private static Optional<LogPoint> createLogPointAndLogBeforeSql(LoggerContext loggerContext, LoggerContext.Category category, Class<?> clazz, Connection connection, String sql, Object ... parameters) {
        Optional<LogPoint> lp = loggerContext.createLogPoint(category, clazz);
        lp.ifPresent(_lp -> _lp.logBeforeSql(connection, sql, parameters));
        return lp;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <R> R executeQueryAndClose(Connection connection, ResultSetTraverser<R> resultSetTraverser, FunctionHandler<Connection, PreparedStatement> statementSupplier) {
        try (PreparedStatement stmt = statementSupplier.apply(connection);){
            R r;
            block14: {
                ResultSet resultSet = stmt.executeQuery();
                try {
                    r = resultSetTraverser.traverseAndMap(resultSet);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <R> R executeQueryAndClose(LoggerContext loggerContext, Connection connection, PreparedStatementSupplier statementSupplier, SqlParametersSetter sqlParametersSetter, String sql, Object[] parameters, ResultSetTraverser<R> resultSetTraverser) {
        Optional<LogPoint> lp = OrmConnectionImpl.createLogPointAndLogBeforeSql(loggerContext, LoggerContext.Category.EXECUTE_QUERY, OrmConnectionImpl.class, connection, sql, parameters);
        try (PreparedStatement stmt = statementSupplier.prepareStatement(connection, sql);){
            sqlParametersSetter.setParameters(stmt, parameters);
            ResultSet resultSet = stmt.executeQuery();
            R ret = resultSetTraverser.traverseAndMap(resultSet);
            lp.ifPresent(_lp -> _lp.logAfterQuery(ret));
            R r = ret;
            return r;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    private static int executeUpdateAndClose(LoggerContext loggerContext, Connection connection, SqlParametersSetter sqlParametersSetter, PreparedStatementSupplier statementSupplier, String sql, Object[] parameters) {
        int n;
        block8: {
            Optional<LogPoint> lp = OrmConnectionImpl.createLogPointAndLogBeforeSql(loggerContext, LoggerContext.Category.EXECUTE_QUERY, OrmConnectionImpl.class, connection, sql, parameters);
            PreparedStatement stmt = statementSupplier.prepareStatement(connection, sql);
            try {
                sqlParametersSetter.setParameters(stmt, parameters);
                int ret = stmt.executeUpdate();
                lp.ifPresent(_lp -> _lp.logAfterUpdate(ret));
                n = ret;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            stmt.close();
        }
        return n;
    }

    private static int getOneSqlType(Class<?> objectClass, ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        if (metaData.getColumnCount() != 1) {
            throw new SormException("ResultSet returned [" + metaData.getColumnCount() + "] columns but 1 column was expected to load data into an instance of [" + objectClass.getName() + "]");
        }
        return metaData.getColumnType(1);
    }

    public static boolean getAutoCommit(Connection connection) {
        try {
            return connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    public static void commitOrRollback(Connection connection, boolean origAutoCommit) {
        try {
            if (origAutoCommit) {
                connection.commit();
            } else {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    public static void setAutoCommit(Connection connection, boolean autoCommit) {
        try {
            connection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public <T> TableMappedOrmConnection<T> mapToTable(Class<T> type) {
        return new TableMappedOrmConnectionImpl<T>(this, type);
    }

    @Override
    public <T> TableMappedOrmConnection<T> mapToTable(Class<T> type, String tableName) {
        return new TableMappedOrmConnectionImpl<T>(this, type, tableName);
    }

    private static class ColumnsAndTypes {
        private final List<String> columns;
        private final List<Integer> columnTypes;

        private static ColumnsAndTypes createColumnsAndTypes(ResultSet resultSet) throws SQLException {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int colNum = metaData.getColumnCount();
            ArrayList<String> columns = new ArrayList<String>(colNum);
            ArrayList<Integer> columnTypes = new ArrayList<Integer>(colNum);
            for (int i = 1; i <= colNum; ++i) {
                columns.add(metaData.getColumnLabel(i));
                columnTypes.add(metaData.getColumnType(i));
            }
            return new ColumnsAndTypes(columns, columnTypes);
        }

        private ColumnsAndTypes(List<String> columns, List<Integer> columnTypes) {
            this.columns = columns;
            this.columnTypes = columnTypes;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<Integer> getColumnTypes() {
            return this.columnTypes;
        }
    }
}

