/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.result;

import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.result.RowMap;

public final class RowMapImpl
implements RowMap {
    private final Map<String, Object> map;

    public RowMapImpl() {
        this(new LinkedHashMap<String, Object>());
    }

    public RowMapImpl(Map<String, Object> map) {
        this.map = map.entrySet().stream().collect(Collectors.toMap(en -> RowMapImpl.toKey(en.getKey()), en -> en.getValue(), (v1, v2) -> v1, LinkedHashMap::new));
    }

    public RowMapImpl(int initialCapacity, float loadFactor) {
        this(new LinkedHashMap<String, Object>(initialCapacity, loadFactor));
    }

    private static String toKey(Object key) {
        return StringCache.toCanonicalCase(key.toString());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(RowMapImpl.toKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(RowMapImpl.toKey(key));
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(RowMapImpl.toKey(key), value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(RowMapImpl.toKey(key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        return Objects.equals(this.map, other);
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public String getString(String key) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    @Override
    public Integer getInteger(String key) {
        return this.getNumberHelper(key, Integer.class, (clazz, val) -> Number.class.isAssignableFrom((Class<?>)clazz) ? ((Number)val).intValue() : Integer.valueOf(val.toString()).intValue());
    }

    @Override
    public Long getLong(String key) {
        return this.getNumberHelper(key, Long.class, (clazz, val) -> Number.class.isAssignableFrom((Class<?>)clazz) ? ((Number)val).longValue() : Long.valueOf(val.toString()).longValue());
    }

    @Override
    public Float getFloat(String key) {
        return this.getNumberHelper(key, Float.class, (clazz, val) -> Float.valueOf(Number.class.isAssignableFrom((Class<?>)clazz) ? ((Number)val).floatValue() : Float.valueOf(val.toString()).floatValue()));
    }

    @Override
    public Double getDouble(String key) {
        return this.getNumberHelper(key, Double.class, (clazz, val) -> Number.class.isAssignableFrom((Class<?>)clazz) ? ((Number)val).doubleValue() : Double.valueOf(val.toString()).doubleValue());
    }

    private <T> T getNumberHelper(String key, Class<T> toType, BiFunction<Class<?>, Object, T> function) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        Class<?> clazz = val.getClass();
        return function.apply(clazz, val);
    }

    @Override
    public LocalDate getLocalDate(String key) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return ((Date)val).toLocalDate();
        }
        return LocalDate.parse(val.toString());
    }

    @Override
    public LocalTime getLocalTime(String key) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Time) {
            return ((Time)val).toLocalTime();
        }
        return LocalTime.parse(val.toString());
    }

    @Override
    public LocalDateTime getLocalDateTime(String key) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Timestamp) {
            return ((Timestamp)val).toLocalDateTime();
        }
        return LocalDateTime.parse(val.toString());
    }

    @Override
    public <T> T[] getArray(String key, Class<T> valueType) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        try {
            return ArrayUtils.convertToObjectArray(valueType, ((Array)val).getArray());
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }
}

