/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.sql;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.util.sql.SelectSql;

@Experimental
public class H2CsvFunctions {
    private H2CsvFunctions() {
    }

    public static String getCallCsvWriteSql(File toFile, String selectSql, Charset charset, String fieldSeparator) {
        String csvOptions = "charset=" + charset.name() + " fieldSeparator=" + fieldSeparator;
        String csvStmt = "call csvwrite(" + SelectSql.literal(toFile.getAbsolutePath()) + "," + SelectSql.literal(selectSql) + "," + SelectSql.literal(csvOptions) + ")";
        return csvStmt;
    }

    public static String getCsvReadSql(File csvFile, List<String> csvColumns, Charset charset, String fieldSeparator) {
        String csvOptions = "charset=" + charset.name() + " fieldSeparator=" + fieldSeparator;
        String readCsvSql = "csvread(" + SelectSql.literal(csvFile.getAbsolutePath()) + "," + (String)(csvColumns == null || csvColumns.size() == 0 ? "null" : "'" + String.join((CharSequence)fieldSeparator, csvColumns) + "'") + "," + SelectSql.literal(csvOptions) + ")";
        return readCsvSql;
    }

    public static String getCsvReadAndSelectSql(List<String> selectedColumns, File csvFile, List<String> csvColumns, Charset charset, String fieldSeparator) {
        return "select " + (selectedColumns == null || selectedColumns.size() == 0 ? "*" : String.join((CharSequence)fieldSeparator, selectedColumns)) + " from " + H2CsvFunctions.getCsvReadSql(csvFile, csvColumns, charset, fieldSeparator);
    }
}

