/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.sql;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.util.h2.sql.H2CsvFunctions;

@Experimental
public class H2CsvReadSql {
    private final List<String> columns;
    private final String csvReadAndSelectSql;

    public static Builder builder(File csvFile) {
        return new Builder(csvFile);
    }

    public H2CsvReadSql(List<String> columns, String csvReadAndSelectSql) {
        this.columns = columns;
        this.csvReadAndSelectSql = csvReadAndSelectSql;
    }

    public String getCsvReadAndInsertSql(String tableName) {
        return "insert into " + tableName + "(" + String.join((CharSequence)",", this.columns) + ") " + this.getCsvReadAndSelectSql();
    }

    public String getCsvReadAndSelectSql() {
        return this.csvReadAndSelectSql;
    }

    public String toString() {
        return "H2CsvReadSql [columns=" + this.columns + ", csvReadAndSelectSql=" + this.csvReadAndSelectSql + "]";
    }

    public static class Builder {
        private List<String> columns = new ArrayList<String>();
        private Map<String, String> aliases = new HashMap<String, String>();
        private List<String> csvColumns = new ArrayList<String>();
        private final File csvFile;
        private Charset charset = StandardCharsets.UTF_8;
        private String fieldSeparator = ",";

        public Builder(File csvFile) {
            this.csvFile = csvFile;
        }

        public H2CsvReadSql build() {
            ArrayList<String> columnsWithAlias = new ArrayList<String>(this.columns);
            this.aliases.entrySet().forEach(en -> {
                int index = columnsWithAlias.indexOf(en.getKey());
                if (index == -1) {
                    throw new IllegalStateException(ParameterizedStringUtils.newString("{} is not found in Columns {}", en.getKey(), this.columns));
                }
                columnsWithAlias.set(index, (String)en.getValue());
            });
            return new H2CsvReadSql(this.columns, H2CsvFunctions.getCsvReadAndSelectSql(columnsWithAlias, this.csvFile, this.csvColumns, this.charset, this.fieldSeparator));
        }

        public Builder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder setFieldSeparator(String fieldSeparator) {
            this.fieldSeparator = fieldSeparator;
            return this;
        }

        public Builder setCharset(String charset) {
            return this.setCharset(Charset.forName(charset));
        }

        public Builder setColumns(List<String> columns) {
            this.columns = new ArrayList<String>(columns);
            return this;
        }

        public Builder setDateTimePatternToColumns(String dateTimePattern, List<String> columns) {
            columns.forEach(column -> this.aliases.put((String)column, "parsedatetime(`" + column + "`,'" + dateTimePattern + "') as " + column));
            return this;
        }

        public Builder setExpressionToColumn(String expression, String column) {
            this.aliases.put(column, expression + " as " + column);
            return this;
        }

        public String toString() {
            return "Builder [columns=" + this.columns + ", aliases=" + this.aliases + ", csvColumns=" + this.csvColumns + ", csvFile=" + this.csvFile + ", charset=" + this.charset + ", fieldSeparator=" + this.fieldSeparator + "]";
        }
    }
}

