package org.nkjmlab.sorm4j.common;

import java.util.List;
import org.nkjmlab.sorm4j.annotation.OrmColumnAliasPrefix;

/**
 * An instance of this class contains table metadata.
 *
 * @author yuu_nkjm
 *
 */
public interface TableMetaData {

  /**
   * Gets auto generated columns list.
   *
   * @return
   */
  List<String> getAutoGeneratedColumns();

  /**
   * <p>
   * Creates a string of column aliases.
   *
   * <p>
   * For example, if the "customer" table has "id" and "name" columns, and
   * {@link OrmColumnAliasPrefix} is "c" returns
   * <code>"customer.id as cid, customer.name as cname"</code>.
   *
   * @return column aliases (e.g. <code>"customer.id as cid, customer.name as cname"</code>)
   */

  String getColumnAliases();

  List<String> getColumns();

  List<String> getColumnsForUpdate();

  List<ColumnMetaData> getColumnsWithMetaData();

  List<String> getNotAutoGeneratedColumns();

  List<String> getNotPrimaryKeys();

  List<String> getPrimaryKeys();

  String getTableName();

  boolean hasAutoGeneratedColumns();

  boolean hasPrimaryKey();

}
