/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.context;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.context.ColumnValueToJavaObjectConverter;
import org.nkjmlab.sorm4j.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.internal.util.ClassUtils;
import org.nkjmlab.sorm4j.internal.util.JdbcTypeUtils;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.util.h2.datatype.Json;

public final class DefaultColumnValueToJavaObjectConverters
implements ColumnValueToJavaObjectConverters {
    private final Map<Class<?>, ColumnValueToJavaObjectConverter<?>> converters;
    private static final Set<Class<?>> supportedTypes = Set.of(Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, InputStream.class, Reader.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, String.class, Object.class, BigDecimal.class, Clob.class, Blob.class, Date.class, Time.class, Timestamp.class, Instant.class, LocalDate.class, LocalTime.class, LocalDateTime.class, OffsetTime.class, OffsetDateTime.class, java.util.Date.class, UUID.class, List.class);

    public DefaultColumnValueToJavaObjectConverters() {
        this(Collections.emptyMap());
    }

    public DefaultColumnValueToJavaObjectConverters(Map<Class<?>, ColumnValueToJavaObjectConverter<?>> converters) {
        this.converters = Map.copyOf(converters);
    }

    @Override
    public <T> T convertTo(ResultSet resultSet, int columnIndex, int columnType, Class<T> toType) {
        try {
            return (T)this.convertToHelper(resultSet, columnIndex, columnType, toType);
        }
        catch (Exception e) {
            throw new SormException(ParameterizedStringUtils.newString("ColumnIndex={},ColumnType={},toType={}", columnIndex, JdbcTypeUtils.convert(columnType), toType), e);
        }
    }

    private Object convertToHelper(ResultSet resultSet, int columnIndex, int columnType, Class<?> toType) throws SQLException {
        ColumnValueToJavaObjectConverter<?> converter = this.converters.get(toType);
        if (converter != null) {
            return converter.convertTo(resultSet, columnIndex, columnType, toType);
        }
        switch (toType.getName()) {
            case "boolean": {
                return resultSet.getBoolean(columnIndex);
            }
            case "java.lang.Boolean": {
                boolean ret = resultSet.getBoolean(columnIndex);
                return !ret && resultSet.wasNull() ? null : Boolean.valueOf(ret);
            }
            case "byte": {
                return resultSet.getByte(columnIndex);
            }
            case "java.lang.Byte": {
                byte ret = resultSet.getByte(columnIndex);
                return ret == 0 && resultSet.wasNull() ? null : Byte.valueOf(ret);
            }
            case "short": {
                return resultSet.getShort(columnIndex);
            }
            case "java.lang.Short": {
                short ret = resultSet.getShort(columnIndex);
                return ret == 0 && resultSet.wasNull() ? null : Short.valueOf(ret);
            }
            case "int": {
                return resultSet.getInt(columnIndex);
            }
            case "java.lang.Integer": {
                int ret = resultSet.getInt(columnIndex);
                return ret == 0 && resultSet.wasNull() ? null : Integer.valueOf(ret);
            }
            case "long": {
                return resultSet.getLong(columnIndex);
            }
            case "java.lang.Long": {
                long ret = resultSet.getLong(columnIndex);
                return ret == 0L && resultSet.wasNull() ? null : Long.valueOf(ret);
            }
            case "float": {
                return Float.valueOf(resultSet.getFloat(columnIndex));
            }
            case "java.lang.Float": {
                float ret = resultSet.getFloat(columnIndex);
                return ret == 0.0f && resultSet.wasNull() ? null : Float.valueOf(ret);
            }
            case "double": {
                return resultSet.getDouble(columnIndex);
            }
            case "java.lang.Double": {
                double ret = resultSet.getDouble(columnIndex);
                return ret == 0.0 && resultSet.wasNull() ? null : Double.valueOf(ret);
            }
            case "java.lang.String": {
                return resultSet.getString(columnIndex);
            }
            case "java.lang.Character": 
            case "char": {
                String str = resultSet.getString(columnIndex);
                return str == null || str.length() == 0 ? null : Character.valueOf(str.charAt(0));
            }
            case "java.lang.Object": {
                return resultSet.getObject(columnIndex);
            }
            case "java.io.InputStream": {
                return resultSet.getBinaryStream(columnIndex);
            }
            case "java.io.Reader": {
                return resultSet.getCharacterStream(columnIndex);
            }
            case "java.math.BigDecimal": {
                return resultSet.getBigDecimal(columnIndex);
            }
            case "java.sql.Date": {
                return resultSet.getDate(columnIndex);
            }
            case "java.sql.Time": {
                return resultSet.getTime(columnIndex);
            }
            case "java.sql.Timestamp": {
                return resultSet.getTimestamp(columnIndex);
            }
            case "java.sql.Blob": {
                return resultSet.getBlob(columnIndex);
            }
            case "java.sql.Clob": {
                return resultSet.getClob(columnIndex);
            }
            case "java.util.Date": 
            case "java.time.LocalTime": 
            case "java.time.LocalDate": 
            case "java.time.LocalDateTime": 
            case "java.time.Instant": 
            case "java.util.UUID": 
            case "java.time.OffsetTime": 
            case "java.time.OffsetDateTime": {
                return resultSet.getObject(columnIndex, toType);
            }
            case "java.util.ArrayList": 
            case "java.util.List": {
                java.sql.Array arry = resultSet.getArray(columnIndex);
                Object srcArry = arry.getArray();
                int length = Array.getLength(srcArry);
                ArrayList<Object> ret = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    ret.add(Array.get(srcArry, i));
                }
                return ret;
            }
            case "org.nkjmlab.sorm4j.util.h2.datatype.Json": {
                return new Json(resultSet.getBytes(columnIndex));
            }
        }
        if (toType.isEnum()) {
            try {
                return Enum.valueOf(toType, resultSet.getString(columnIndex));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (toType.isArray()) {
            String compName;
            switch (compName = toType.getComponentType().getName()) {
                case "byte": {
                    return resultSet.getBytes(columnIndex);
                }
            }
            try {
                return ArrayUtils.convertToArray(ClassUtils.convertToClass(compName), resultSet.getArray(columnIndex).getArray());
            }
            catch (Exception e) {
                throw new SormException(ParameterizedStringUtils.newString("Could not convert column ({}) to  array ({}[])", JDBCType.valueOf(columnType).getName(), compName), e);
            }
        }
        return resultSet.getObject(columnIndex, toType);
    }

    @Override
    public boolean isSupportedReturnedType(Class<?> objectClass) {
        return supportedTypes.contains(objectClass) || objectClass.isArray();
    }
}

