/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nkjmlab.sorm4j.internal.util.ClassUtils;

public final class ArrayUtils {
    private static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    private static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    private static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    private static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    private static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    private static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    private static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    private static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];

    public static int[] add(int[] array, int i) {
        int arrayLength = Array.getLength(array);
        int[] newArray = new int[arrayLength + 1];
        System.arraycopy(array, 0, newArray, 0, arrayLength);
        newArray[arrayLength] = i;
        return newArray;
    }

    @SafeVarargs
    public static <T> List<T[]> split(int size, T ... objects) {
        int slotNum = Math.floorDiv(objects.length, size);
        ArrayList<T[]> result = new ArrayList<T[]>(slotNum + 1);
        for (int i = 0; i < slotNum; ++i) {
            result.add(Arrays.copyOfRange(objects, size * i, size * (i + 1)));
        }
        if (size * slotNum != objects.length) {
            result.add(Arrays.copyOfRange(objects, size * slotNum, objects.length));
        }
        return result;
    }

    public static Boolean[] toObjectArray(boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Byte[] toObjectArray(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Character[] toObjectArray(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    public static Double[] toObjectArray(double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Float[] toObjectArray(float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static Integer[] toObjectArray(int[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Long[] toObjectArray(long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Short[] toObjectArray(short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    private ArrayUtils() {
    }

    public static Object convertToArray(Class<?> valueType, Object srcArray) {
        int length = Array.getLength(srcArray);
        Object destArray = Array.newInstance(valueType, length);
        for (int i = 0; i < length; ++i) {
            Object v = Array.get(srcArray, i);
            Array.set(destArray, i, v);
        }
        return destArray;
    }

    public static <T> T[] convertToObjectArray(Class<?> componentType, Object srcArray) {
        int length = Array.getLength(srcArray);
        Object destArray = Array.newInstance(componentType.isPrimitive() ? ClassUtils.primitiveToWrapper(componentType) : componentType, length);
        for (int i = 0; i < length; ++i) {
            Object v = Array.get(srcArray, i);
            Array.set(destArray, i, v);
        }
        Object[] ret = (Object[])destArray;
        return ret;
    }
}

